/*
 * Decompiled with CFR 0.152.
 */
package ladylib.client.particle;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import ladylib.LadyLib;
import ladylib.client.particle.IParticleDrawingStage;
import ladylib.client.particle.ISpecialParticle;
import ladylib.config.LLConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LLParticleManager {
    private final Map<IParticleDrawingStage, Queue<ISpecialParticle>> particles = new HashMap<IParticleDrawingStage, Queue<ISpecialParticle>>();
    private final Set<ResourceLocation> particleTextures = new HashSet<ResourceLocation>();

    public static LLParticleManager getInstance() {
        return LadyLib.getParticleManager();
    }

    public void registerParticleTexture(ResourceLocation location) {
        this.particleTextures.add(location);
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        this.particleTextures.forEach(arg_0 -> ((TextureMap)event.getMap()).func_174942_a(arg_0));
    }

    @SubscribeEvent
    public void onGameTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.updateParticles();
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.renderParticles(event.getPartialTicks());
    }

    private void updateParticles() {
        int count = 0;
        for (Queue<ISpecialParticle> particleQueue : this.particles.values()) {
            Iterator iterator = particleQueue.iterator();
            while (iterator.hasNext() && ++count <= 3 * LLConfig.maxParticles) {
                ISpecialParticle particle = (ISpecialParticle)iterator.next();
                particle.updateParticle();
                if (!particle.isDead()) continue;
                iterator.remove();
            }
        }
    }

    private void renderParticles(float partialTicks) {
        float x = ActiveRenderInfo.func_178808_b();
        float z = ActiveRenderInfo.func_178803_d();
        float yz = ActiveRenderInfo.func_178805_e();
        float xy = ActiveRenderInfo.func_178807_f();
        float xz = ActiveRenderInfo.func_178809_c();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            LLParticleManager.updateParticleFields(partialTicks, (EntityPlayer)player);
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)false);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buffer = tess.func_178180_c();
            int particleCount = 0;
            block0: for (Map.Entry<IParticleDrawingStage, Queue<ISpecialParticle>> particleStage : this.particles.entrySet()) {
                particleStage.getKey().prepareRender();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                for (ISpecialParticle particle : particleStage.getValue()) {
                    if (++particleCount > LLConfig.maxParticles) {
                        tess.func_78381_a();
                        particleStage.getKey().clear();
                        break block0;
                    }
                    particle.renderParticle(buffer, (EntityPlayer)player, partialTicks, x, xz, z, yz, xy);
                }
                tess.func_78381_a();
                particleStage.getKey().clear();
            }
            GlStateManager.func_179089_o();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179121_F();
        }
    }

    private static void updateParticleFields(float partialTicks, EntityPlayer player) {
        Particle.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = player.func_70676_i(partialTicks);
    }

    public void addParticle(ISpecialParticle p) {
        if (this.particles.values().stream().mapToInt(Collection::size).sum() < LLConfig.maxParticles * 3) {
            this.particles.computeIfAbsent(p.getDrawStage(), i -> new ArrayDeque()).add(p);
        }
    }
}

