/*
 * Decompiled with CFR 0.152.
 */
package ladylib.client.lighting;

import com.google.common.annotations.Beta;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import ladylib.client.lighting.CheapLight;
import ladylib.client.lighting.FramebufferReplacement;
import ladylib.client.shader.ShaderRegistryEvent;
import ladylib.client.shader.ShaderUtil;
import ladylib.compat.EnhancedBusSubscriber;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.util.vector.Matrix4f;

@Beta
@EnhancedBusSubscriber(side={Side.CLIENT})
public class CheapLightManager {
    private static final ResourceLocation LIGHT_TEXTURE = new ResourceLocation("ladylib", "textures/light.png");
    private static final ResourceLocation LIGHT_SHADER = new ResourceLocation("ladylib", "cheap_light");
    public static final int MAX_LIGHTS = 100;
    public static final CheapLightManager INSTANCE = new CheapLightManager();
    private final List<CheapLight> cheapLights = new ArrayList<CheapLight>();
    Matrix4f projectionMatrix = new Matrix4f();
    Matrix4f viewMatrix = new Matrix4f();

    public void addLight(CheapLight light) {
        this.cheapLights.add(light);
    }

    public Stream<CheapLight> getLights() {
        return this.cheapLights.stream();
    }

    @SubscribeEvent
    void onShaderRegistry(ShaderRegistryEvent event) {
        event.registerShader(LIGHT_SHADER);
    }

    @SubscribeEvent
    void onTickClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Entity camera;
            Iterator<CheapLight> iterator = this.cheapLights.iterator();
            while (iterator.hasNext()) {
                CheapLight cheapLight = iterator.next();
                cheapLight.tick();
                if (!cheapLight.isExpired()) continue;
                iterator.remove();
            }
            if (this.cheapLights.size() > 100 && (camera = Minecraft.func_71410_x().func_175606_aa()) != null) {
                this.cheapLights.sort(Comparator.comparing(l -> camera.func_70092_e(l.getPosX(), l.getPosY(), l.getPosZ())));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    void onRenderWorldLast(RenderWorldLastEvent event) {
        if (this.cheapLights.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Entity camera = mc.func_175606_aa();
        if (camera == null) {
            return;
        }
        int depthTexture = FramebufferReplacement.getMainDepthTexture();
        if (depthTexture < 0) {
            return;
        }
        float partialTicks = event.getPartialTicks();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
        GlStateManager.func_179144_i((int)depthTexture);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        mc.func_110434_K().func_110577_a(LIGHT_TEXTURE);
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179112_b((int)770, (int)1);
        ShaderUtil.useShader(LIGHT_SHADER);
        ShaderUtil.setUniform("InverseTransformMatrix", this.computeInverseTransformMatrix());
        ScaledResolution scaledRes = new ScaledResolution(mc);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)scaledRes.func_78327_c(), (double)scaledRes.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        ShaderUtil.setUniform("DepthSampler", 2);
        ShaderUtil.setUniform("PlayerPosition", (float)camera.field_70165_t, (float)camera.field_70163_u, (float)camera.field_70161_v);
        ShaderUtil.setUniform("ViewPort", 0.0f, 0.0f, mc.field_71443_c, mc.field_71440_d);
        ShaderUtil.setUniform("ViewMatrix", ShaderUtil.getModelViewMatrix());
        ShaderUtil.setUniform("ProjectionMatrix", ShaderUtil.getProjectionMatrix());
        int size = Math.min(100, this.cheapLights.size());
        ShaderUtil.setUniform("u_lightCount", size);
        for (int i = 0; i < size; ++i) {
            CheapLight light = this.cheapLights.get(i);
            double x = (float)(light.getLastPosX() + (light.getPosX() - light.getLastPosX()) * (double)partialTicks - Particle.field_70556_an);
            double y = (float)(light.getLastPosY() + (light.getPosY() - light.getLastPosY()) * (double)partialTicks - Particle.field_70554_ao);
            double z = (float)(light.getLastPosZ() + (light.getPosZ() - light.getLastPosZ()) * (double)partialTicks - Particle.field_70555_ap);
            ShaderUtil.setUniform("u_light[" + i + "].position", (float)x, (float)y, (float)z);
            ShaderUtil.setUniform("u_light[" + i + "].color", light.getColor().getRGBComponents(null));
            ShaderUtil.setUniform("u_light[" + i + "].radius", light.getRadius());
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(0.0, (double)scaledRes.func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), (double)scaledRes.func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        ShaderUtil.revert();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179126_j();
    }

    @Nonnull
    private FloatBuffer computeInverseTransformMatrix() {
        this.projectionMatrix.load(ShaderUtil.getProjectionMatrix());
        this.viewMatrix.load(ShaderUtil.getModelViewMatrix());
        Matrix4f projectionViewMatrix = Matrix4f.mul((Matrix4f)this.projectionMatrix, (Matrix4f)this.viewMatrix, null);
        Matrix4f inverseTransformMatrix = Matrix4f.invert((Matrix4f)projectionViewMatrix, (Matrix4f)this.projectionMatrix);
        FloatBuffer buf = ShaderUtil.getTempBuffer();
        inverseTransformMatrix.store(buf);
        buf.rewind();
        return buf;
    }
}

