/*
 * Decompiled with CFR 0.152.
 */
package ladylib.client;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import ladylib.LadyLib;
import ladylib.misc.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class ResourceProxy
extends AbstractResourcePack {
    private static final String BARE_FORMAT = "assets/%s/%s/%s";
    private static final String OVERRIDE_FORMAT = "/assets/%s/%s/overrides/%s";
    private final Map<String, String> overrides = new HashMap<String, String>();
    private final ImmutableSet<String> resourceDomains;

    public ResourceProxy(String ... resourceDomains) {
        super(Objects.requireNonNull(Loader.instance().activeModContainer()).getSource());
        this.overrides.put("pack.mcmeta", "/proxypack.mcmeta");
        this.resourceDomains = ImmutableSet.copyOf((Object[])resourceDomains);
    }

    public void hook() {
        if (Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION)) {
            throw new IllegalStateException("Resource proxies should be registered before pre-initialization");
        }
        List defaultPacks = ReflectionUtil.getPrivateValue(Minecraft.class, Minecraft.func_71410_x(), "field_110449_ao", List.class);
        if (!defaultPacks.contains((Object)this)) {
            defaultPacks.add(this);
        }
    }

    public void addResourceOverride(String owner, String namespace, String dir, String ... files) {
        if (!this.resourceDomains.contains((Object)namespace)) {
            throw new IllegalArgumentException("Can't override resource in unsupported domain " + namespace);
        }
        for (String file : files) {
            String bare = String.format(BARE_FORMAT, namespace, dir, file);
            String override = this.getOverrideLocation(owner, namespace, dir, file);
            this.overrides.put(bare, override);
        }
    }

    protected String getOverrideLocation(String owner, String namespace, String dir, String file) {
        return String.format(OVERRIDE_FORMAT, owner, dir, file);
    }

    @Nonnull
    public Set<String> func_110587_b() {
        return this.resourceDomains;
    }

    @Nonnull
    protected InputStream func_110591_a(@Nonnull String name) {
        return Objects.requireNonNull(LadyLib.class.getResourceAsStream(this.overrides.get(name)), String.format("%s is not an existing resource (overriding %s)", this.overrides.get(name), name));
    }

    protected boolean func_110593_b(@Nonnull String name) {
        return this.overrides.containsKey(name);
    }

    @Nonnull
    public String func_130077_b() {
        return "ladylib-texture-proxy";
    }
}

