/*
 * Decompiled with CFR 0.152.
 */
package ladylib.capability;

import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import ladylib.LadyLib;
import ladylib.nbt.serialization.NBTDeserializationException;
import ladylib.nbt.serialization.NBTTypeAdapter;
import ladylib.nbt.serialization.adapter.ReflectiveNBTAdapterFactory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class ReflectiveCapabilityStorage<C>
implements Capability.IStorage<C> {
    private final Class<C> capClass;
    private final NBTTypeAdapter<C, NBTTagCompound> adapter;

    public ReflectiveCapabilityStorage(Class<C> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Class parameter must be an implementation");
        }
        this.capClass = clazz;
        this.adapter = clazz.getDeclaredFields().length > 0 ? ReflectiveNBTAdapterFactory.INSTANCE.create(clazz) : null;
    }

    @Nullable
    public NBTBase writeNBT(Capability capability, Object instance, EnumFacing side) {
        if (this.adapter == null || !this.capClass.isInstance(instance)) {
            return null;
        }
        return this.adapter.toNBT(this.capClass.cast(instance));
    }

    public void readNBT(Capability capability, Object instance, EnumFacing side, NBTBase nbt) {
        if (this.adapter != null && this.capClass.isInstance(instance)) {
            try {
                this.adapter.fromNBT(this.capClass.cast(instance), nbt);
            }
            catch (NBTDeserializationException e) {
                LadyLib.LOGGER.error("Could not read NBT from capability " + capability.getName(), (Throwable)e);
            }
        }
    }
}

