/*
 * Decompiled with CFR 0.152.
 */
package ladylib;

import com.google.common.collect.SetMultimap;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import ladylib.LLibContainer;
import ladylib.client.ClientHandler;
import ladylib.client.LLibClientContainer;
import ladylib.client.internal.ClientHandlerImpl;
import ladylib.client.particle.LLParticleManager;
import ladylib.compat.internal.EnhancedAutomaticEventSubscriber;
import ladylib.misc.ReflectionFailedException;
import ladylib.nbt.serialization.internal.DefaultValuesSearch;
import ladylib.networking.minecraft.PacketHandler;
import ladylib.registration.BlockRegistrar;
import ladylib.registration.ItemRegistrar;
import ladylib.registration.internal.AutoRegistrar;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.TracingPrintStream;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ladylib", version="2.3", dependencies="required-after:forge@[14.23.3.2665,);", acceptedMinecraftVersions="[1.12.2]")
public class LadyLib {
    public static final String MOD_ID = "ladylib";
    public static final String MOD_NAME = "LadyLib";
    public static final String VERSION = "2.3";
    public static final String DEPENDENCIES = "required-after:forge@[14.23.3.2665,);";
    public static final Logger LOGGER = LogManager.getLogger((String)"LadyLib");
    private static final PrintStream DEBUG_STREAM = new TracingPrintStream(LogManager.getLogger((String)"DEBUG"), System.out);
    private static final Map<String, LLibContainer> allInstances = new HashMap<String, LLibContainer>();
    public static final LadyLib INSTANCE;
    @Deprecated
    public static final LadyLib instance;
    private AutoRegistrar registrar;
    private ClientHandlerImpl clientHandler;

    public static boolean isDevEnv() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static void debug(Object message) {
        if (LadyLib.isDevEnv()) {
            DEBUG_STREAM.println(message);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static LLParticleManager getParticleManager() {
        return LadyLib.INSTANCE.clientHandler.getParticleManager();
    }

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            ClientHandlerImpl.hookResourceProxy();
        }
    }

    @Mod.EventHandler
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        ASMDataTable dataTable = event.getAsmData();
        this.registrar = new AutoRegistrar(dataTable);
        MinecraftForge.EVENT_BUS.register((Object)this.registrar);
        MinecraftForge.EVENT_BUS.register((Object)this.registrar.getItemRegistrar());
        MinecraftForge.EVENT_BUS.register((Object)this.registrar.getBlockRegistrar());
        this.registrar.autoRegisterTileEntities(dataTable);
        EnhancedAutomaticEventSubscriber.inject(dataTable);
        EnhancedAutomaticEventSubscriber.redistributeEvent((FMLStateEvent)event);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.clientHandler = new ClientHandlerImpl();
            this.clientHandler.clientInit();
        }
        this.injectContainers(dataTable);
        DefaultValuesSearch.searchDefaultValues(dataTable);
    }

    @Mod.EventHandler
    public void init(@Nonnull FMLInitializationEvent event) {
        PacketHandler.initPackets();
        EnhancedAutomaticEventSubscriber.redistributeEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        EnhancedAutomaticEventSubscriber.redistributeEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void serverStarting(@Nonnull FMLServerStartingEvent event) {
        EnhancedAutomaticEventSubscriber.redistributeEvent((FMLStateEvent)event);
    }

    private void injectContainers(ASMDataTable asmData) {
        try {
            Method parseSimpleFieldAnnotation = FMLModContainer.class.getDeclaredMethod("parseSimpleFieldAnnotation", SetMultimap.class, String.class, Function.class);
            parseSimpleFieldAnnotation.setAccessible(true);
            for (ModContainer container : Loader.instance().getModList()) {
                SetMultimap annotations = asmData.getAnnotationsFor(container);
                if (!(container instanceof FMLModContainer)) continue;
                parseSimpleFieldAnnotation.invoke((Object)container, annotations, LLInstance.class.getName(), mc -> this.getContainer(mc.getModId()));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectionFailedException("Could not inject LadyLib container instances", e);
        }
    }

    public Collection<LLibContainer> getAllInstances() {
        return allInstances.values();
    }

    public ClientHandler getClientHandler() {
        return this.clientHandler;
    }

    public LLibContainer getContainer(String modId) {
        return allInstances.computeIfAbsent(modId, this::createContainer);
    }

    private LLibContainer createContainer(String modId) {
        ModContainer owner = (ModContainer)Loader.instance().getIndexedModList().get(modId);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return new LLibClientContainer(owner);
        }
        return new LLibContainer(owner);
    }

    public ItemRegistrar getItemRegistrar() {
        return this.registrar.getItemRegistrar();
    }

    public BlockRegistrar getBlockRegistrar() {
        return this.registrar.getBlockRegistrar();
    }

    @Mod.InstanceFactory
    public static LadyLib getModInstance() {
        return INSTANCE;
    }

    static {
        instance = INSTANCE = new LadyLib();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LLInstance {
        public String value() default "";

        public String owner() default "";
    }
}

