/*
 * Decompiled with CFR 0.152.
 */
package ladylib;

import com.google.common.base.Strings;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladylib.misc.ReflectionFailedException;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class LLibContainer {
    private static Map<String, Configuration> configs;
    private ModContainer owner;
    private CreativeTabs creativeTab;

    public LLibContainer(ModContainer owner) {
        this.owner = owner;
    }

    public CreativeTabs makeCreativeTab(final Supplier<ItemStack> icon) {
        CreativeTabs ret = new CreativeTabs(this.owner.getName()){

            @Nonnull
            public ItemStack func_78016_d() {
                return (ItemStack)icon.get();
            }
        };
        this.setCreativeTab(ret);
        return ret;
    }

    public void setCreativeTab(CreativeTabs tab) {
        this.creativeTab = tab;
    }

    public CreativeTabs getCreativeTab() {
        return this.creativeTab;
    }

    public Configuration getMainConfiguration(@Nullable String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            name = this.getModId();
        }
        File configDir = Loader.instance().getConfigDir();
        File configFile = new File(configDir, name + ".cfg");
        return LLibContainer.getForgeConfigs().get(configFile.getAbsolutePath());
    }

    private static Map<String, Configuration> getForgeConfigs() {
        if (configs == null) {
            try {
                Field configsField = ConfigManager.class.getDeclaredField("CONFIGS");
                configsField.setAccessible(true);
                configs = (Map)configsField.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ReflectionFailedException("Error while attempting to access internal configuration", e);
            }
        }
        return configs;
    }

    @Nonnull
    public String getModId() {
        return this.owner.getModId();
    }

    public void addVanillaResourceOverride(String path, String ... files) {
    }
}

