/*
 * Decompiled with CFR 0.152.
 */
package c4.cherishedworlds.core;

import c4.cherishedworlds.CherishedWorlds;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListWorldSelection;
import net.minecraft.client.gui.GuiListWorldSelectionEntry;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ReflectionAccessor {
    private static final Field SELECTION_LIST = ReflectionHelper.findField(GuiWorldSelection.class, (String[])new String[]{"selectionList", "field_184866_u"});
    private static final Field BUTTON_LIST = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
    private static final Field WORLD_SUMMARY = ReflectionHelper.findField(GuiListWorldSelectionEntry.class, (String[])new String[]{"worldSummary", "field_186786_g"});
    private static final Field ENTRIES = ReflectionHelper.findField(GuiListWorldSelection.class, (String[])new String[]{"entries", "field_186799_w"});
    private static final Method GET_SIZE = ReflectionHelper.findMethod(GuiListWorldSelection.class, (String)"getSize", (String)"func_148127_b", (Class[])new Class[0]);

    @Nullable
    public static GuiListWorldSelection getSelectionList(GuiWorldSelection worldSelection) {
        try {
            return (GuiListWorldSelection)SELECTION_LIST.get(worldSelection);
        }
        catch (IllegalAccessException e) {
            CherishedWorlds.logger.error("Could not retrieve selection list of worlds!" + e.getLocalizedMessage());
            return null;
        }
    }

    public static List<GuiButton> getButtonList(GuiScreen guiScreen) {
        try {
            return (List)BUTTON_LIST.get(guiScreen);
        }
        catch (IllegalAccessException e) {
            CherishedWorlds.logger.error("Could not retrieve button list of gui screen!" + e.getLocalizedMessage());
            return Lists.newArrayList();
        }
    }

    @Nullable
    public static WorldSummary getWorldSummary(GuiListWorldSelectionEntry entry) {
        try {
            return (WorldSummary)WORLD_SUMMARY.get(entry);
        }
        catch (IllegalAccessException e) {
            CherishedWorlds.logger.error("Could not retrieve world summary from entry!" + e.getLocalizedMessage());
            return null;
        }
    }

    public static List<GuiListWorldSelectionEntry> getWorldSelectionEntries(GuiListWorldSelection listWorld) {
        try {
            return (List)ENTRIES.get(listWorld);
        }
        catch (IllegalAccessException e) {
            CherishedWorlds.logger.error("Could not retrieve entries from world list!" + e.getLocalizedMessage());
            return Lists.newArrayList();
        }
    }

    public static int getSize(GuiListWorldSelection listWorld) {
        try {
            return (Integer)GET_SIZE.invoke((Object)listWorld, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CherishedWorlds.logger.error("Could not retrieve size of world list!" + e.getLocalizedMessage());
            return 0;
        }
    }
}

