/*
 * Decompiled with CFR 0.152.
 */
package net.tangotek.cyclopstek.client;

import com.leviathanstudio.craftstudio.client.model.CSModelRenderer;
import com.leviathanstudio.craftstudio.client.model.ModelCraftStudio;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.model.ModelRenderer;

public class ModelBlockChain {
    private final ModelCraftStudio mainModel;
    private LinkedList<CSModelRenderer> blockChain = new LinkedList();

    public ModelBlockChain(ModelCraftStudio model, String blockName) {
        this.mainModel = model;
        this.mainModel.getParentBlocks().forEach(m -> this.buildBlockChain((CSModelRenderer)m, (List<CSModelRenderer>)this.blockChain, blockName));
        if (this.blockChain.isEmpty()) {
            throw new RuntimeException("Error building ModelCraftStudio block chain. Block not found: " + blockName);
        }
    }

    private boolean buildBlockChain(CSModelRenderer model, List<CSModelRenderer> blockChain, String blockName) {
        if (model.field_78802_n.equals(blockName)) {
            blockChain.add(model);
            return true;
        }
        if (model.field_78805_m != null) {
            for (ModelRenderer childModel : model.field_78805_m) {
                CSModelRenderer m = (CSModelRenderer)childModel;
                if (!this.buildBlockChain(m, blockChain, blockName)) continue;
                blockChain.add(0, model);
                return true;
            }
        }
        return false;
    }

    private void applyModelRenderer(CSModelRenderer modelRenderer, Matrix4f transform, float yOffset) {
        Matrix4f work = new Matrix4f();
        Vector3f translate = modelRenderer.getPositionAsVector();
        translate.y -= yOffset;
        translate.scale(0.0625f);
        work.set(translate);
        transform.mul(work);
        Matrix4f rot = modelRenderer.getRotationMatrix();
        rot.invert();
        transform.mul(rot);
        Vector3f offset = modelRenderer.getOffsetAsVector();
        offset.scale(0.0625f);
        work.set(offset);
        transform.mul(work);
    }

    public void transform(Point3f point) {
        Matrix4f trans = new Matrix4f();
        trans.setIdentity();
        boolean first = true;
        for (CSModelRenderer modelRenderer : this.blockChain) {
            this.applyModelRenderer(modelRenderer, trans, first ? 24.0f : 0.0f);
            first = false;
        }
        trans.transform(point);
    }
}

