/*
 * Decompiled with CFR 0.152.
 */
package net.tangotek.cyclopstek.client;

import com.leviathanstudio.craftstudio.client.model.ModelCraftStudio;
import javax.vecmath.Point3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tangotek.cyclopstek.CyclopsTek;
import net.tangotek.cyclopstek.EntityCyclops;
import net.tangotek.cyclopstek.client.ModelBlockChain;
import net.tangotek.cyclopstek.client.RenderCyclops;

@SideOnly(value=Side.CLIENT)
public class LayerCyclopsBeam
implements LayerRenderer<EntityCyclops> {
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("cyclopstek", "textures/entity/red_laser.png");
    private final RenderCyclops cyclopsRender;
    private final ModelBlockChain eyeBlockChain;
    private boolean beamActive = false;
    private float lastPartialTicks;
    private float partialTickProgress;
    private Vec3d lastFocusPos;
    private Vec3d curFocusPos;

    public LayerCyclopsBeam(RenderCyclops cyclopsRenderIn) {
        this.cyclopsRender = cyclopsRenderIn;
        this.eyeBlockChain = new ModelBlockChain((ModelCraftStudio)cyclopsRenderIn.func_177087_b(), "Eye");
    }

    protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    public void doRenderLayer(EntityCyclops cyclops, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (cyclops.isAnimationActive("cyclops_eye_beam")) {
            float rMain = this.interpolateRotation(cyclops.field_70760_ar, cyclops.field_70761_aq, partialTicks);
            float rHead = this.interpolateRotation(cyclops.field_70758_at, cyclops.field_70759_as, partialTicks);
            double cyclopsX = cyclops.field_70165_t + (cyclops.field_70169_q - cyclops.field_70165_t) * (double)(1.0f - partialTicks);
            double cyclopsY = cyclops.field_70163_u + (cyclops.field_70167_r - cyclops.field_70163_u) * (double)(1.0f - partialTicks);
            double cyclopsZ = cyclops.field_70161_v + (cyclops.field_70166_s - cyclops.field_70161_v) * (double)(1.0f - partialTicks);
            Point3f cyclopsPos = new Point3f((float)cyclopsX, (float)cyclopsY, (float)cyclopsZ);
            Point3f eyeOffset = new Point3f(0.0f, 0.0f, 0.0f);
            this.eyeBlockChain.transform(eyeOffset);
            Vec3d eyeOffsetRotated = new Vec3d((double)eyeOffset.x, (double)eyeOffset.y, (double)eyeOffset.z);
            eyeOffsetRotated = eyeOffsetRotated.func_178785_b(rMain * ((float)Math.PI / 180));
            Vec3d startPos = new Vec3d((double)cyclopsPos.x + eyeOffsetRotated.field_72450_a, (double)cyclopsPos.y - eyeOffsetRotated.field_72448_b, (double)cyclopsPos.z - eyeOffsetRotated.field_72449_c);
            this.spawnParticle(cyclops, startPos, 1.0f);
            if (cyclops.isEyeBeamActive()) {
                Vec3d renderFocusPos;
                Vec3d focusPos = cyclops.getFocusPos();
                if (this.beamActive) {
                    if (focusPos != this.curFocusPos) {
                        this.lastFocusPos = this.curFocusPos;
                        this.curFocusPos = focusPos;
                        this.partialTickProgress = 0.0f;
                    } else {
                        float tickDelta = partialTicks - this.lastPartialTicks;
                        if (this.lastPartialTicks > partialTicks) {
                            tickDelta = 1.0f + tickDelta;
                        }
                        this.partialTickProgress = Math.min(1.0f, tickDelta + this.partialTickProgress);
                    }
                    renderFocusPos = this.lastFocusPos.func_178787_e(this.curFocusPos.func_178788_d(this.lastFocusPos).func_186678_a((double)this.partialTickProgress));
                } else {
                    this.beamActive = true;
                    this.curFocusPos = focusPos;
                    this.lastFocusPos = focusPos;
                    renderFocusPos = focusPos;
                    this.partialTickProgress = 0.0f;
                }
                this.lastPartialTicks = partialTicks;
                float f = partialTicks;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                this.cyclopsRender.func_110776_a(BEAM_TEXTURE);
                GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
                GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
                GlStateManager.func_179140_f();
                GlStateManager.func_179129_p();
                GlStateManager.func_179084_k();
                GlStateManager.func_179132_a((boolean)true);
                float f1 = 240.0f;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                float f2 = (float)cyclops.field_70170_p.func_82737_E() + partialTicks;
                float f3 = f2 * 0.5f % 1.0f;
                float f4 = cyclops.func_70047_e();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
                GlStateManager.func_179109_b((float)eyeOffset.x, (float)eyeOffset.y, (float)eyeOffset.z);
                Vec3d vec3d = renderFocusPos;
                Vec3d vec3d2 = vec3d.func_178788_d(startPos);
                double d0 = vec3d2.func_72433_c();
                vec3d2 = vec3d2.func_72432_b();
                float f5 = (float)Math.acos(-vec3d2.field_72448_b);
                float f6 = (float)Math.atan2(vec3d2.field_72449_c, vec3d2.field_72450_a);
                this.spawnParticle(cyclops, renderFocusPos, 1.4f);
                float beamRot = MathHelper.func_76142_g((float)(270.0f - -f6 * 57.295776f));
                float finalRot = beamRot - rMain;
                GlStateManager.func_179114_b((float)(180.0f + finalRot), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(f5 * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                boolean i = true;
                double d1 = (double)f2 * 0.05 * -1.5;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                float f7 = f * f;
                int j = 192 + (int)(f7 * 64.0f);
                int k = 128 - (int)(f7 * 64.0f);
                int l = 128 - (int)(f7 * 64.0f);
                double d2 = 0.2;
                double d3 = 0.282;
                double d4 = 0.0 + Math.cos(d1 + 2.356194490192345) * 0.282;
                double d5 = 0.0 + Math.sin(d1 + 2.356194490192345) * 0.282;
                double d6 = 0.0 + Math.cos(d1 + 0.7853981633974483) * 0.282;
                double d7 = 0.0 + Math.sin(d1 + 0.7853981633974483) * 0.282;
                double d8 = 0.0 + Math.cos(d1 + 3.9269908169872414) * 0.282;
                double d9 = 0.0 + Math.sin(d1 + 3.9269908169872414) * 0.282;
                double d10 = 0.0 + Math.cos(d1 + 5.497787143782138) * 0.282;
                double d11 = 0.0 + Math.sin(d1 + 5.497787143782138) * 0.282;
                double BEAM_RADIUS = 0.1;
                double d12 = 0.0 + Math.cos(d1 + Math.PI) * 0.1;
                double d13 = 0.0 + Math.sin(d1 + Math.PI) * 0.1;
                double d14 = 0.0 + Math.cos(d1 + 0.0) * 0.1;
                double d15 = 0.0 + Math.sin(d1 + 0.0) * 0.1;
                double d16 = 0.0 + Math.cos(d1 + 1.5707963267948966) * 0.1;
                double d17 = 0.0 + Math.sin(d1 + 1.5707963267948966) * 0.1;
                double d18 = 0.0 + Math.cos(d1 + 4.71238898038469) * 0.1;
                double d19 = 0.0 + Math.sin(d1 + 4.71238898038469) * 0.1;
                double d20 = 0.0;
                double d21 = 0.4999;
                double d22 = -1.0f + f3;
                double d23 = d0 * 2.5 + d22;
                bufferbuilder.func_181662_b(d12, d0, d13).func_187315_a(0.4999, d23).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d12, 0.0, d13).func_187315_a(0.4999, d22).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d14, 0.0, d15).func_187315_a(0.0, d22).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d14, d0, d15).func_187315_a(0.0, d23).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d16, d0, d17).func_187315_a(0.4999, d23).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d16, 0.0, d17).func_187315_a(0.4999, d22).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d18, 0.0, d19).func_187315_a(0.0, d22).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d18, d0, d19).func_187315_a(0.0, d23).func_181669_b(j, k, l, 255).func_181675_d();
                double d24 = 0.0;
                if (cyclops.field_70173_aa % 2 == 0) {
                    d24 = 0.5;
                }
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            } else {
                this.beamActive = false;
            }
        }
    }

    private void spawnParticle(EntityCyclops cyclops, Vec3d pos, float speedMod) {
        for (int i = 0; i < 2; ++i) {
            Minecraft.func_71410_x().field_71452_i.func_178927_a(CyclopsTek.PARTICLE_EYE_GLOW.intValue(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, cyclops.func_70681_au().nextGaussian() * (double)0.07f * (double)speedMod, cyclops.func_70681_au().nextGaussian() * (double)0.1f * (double)speedMod, cyclops.func_70681_au().nextGaussian() * (double)0.07f * (double)speedMod, new int[0]);
        }
    }

    public boolean func_177142_b() {
        return true;
    }
}

