/*
 * Decompiled with CFR 0.152.
 */
package net.tangotek.cyclopstek;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.tangotek.cyclopstek.EntityCyclops;

public class WorldGenCyclopsIsland
extends WorldGenerator
implements IWorldGenerator {
    private int spacing = 32;
    private int separation = 5;
    public static final List<Biome> SPAWN_BIOMES = Arrays.asList(Biomes.field_150575_M);

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        return false;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        WorldServer worldServer = (WorldServer)world;
        MinecraftServer minecraftServer = world.func_73046_m();
        TemplateManager templateManager = worldServer.func_184163_y();
        Template template = templateManager.func_186237_a(minecraftServer, new ResourceLocation("cyclopstek:cyclops_island1"));
        if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
            int blockX = chunkX * 16 + 8;
            int blockZ = chunkZ * 16 + 8;
            if (template == null) {
                System.out.println("No Cyclops Structure file");
            }
            if (this.canSpawnAtCoords(worldServer, chunkX, chunkZ)) {
                BlockPos blockPos = new BlockPos(blockX, world.func_181545_F() - 23, blockZ);
                IBlockState blockState = world.func_180495_p(blockPos);
                world.func_184138_a(blockPos, blockState, blockState, 3);
                PlacementSettings placeSettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(null).func_186225_a(Blocks.field_189881_dj).func_186226_b(false);
                template.func_186258_a(blockPos, placeSettings);
                template.func_186253_b(world, blockPos.func_177982_a(0, 1, 0), placeSettings);
                EntityCyclops cyclops = new EntityCyclops(world);
                cyclops.func_110163_bv();
                cyclops.func_70012_b((double)blockPos.func_177958_n() + 12.5, (double)blockPos.func_177956_o() + 4.0, (double)blockPos.func_177952_p() + 18.0, 0.0f, 0.0f);
                cyclops.func_180482_a(world.func_175649_E(blockPos), null);
                world.func_72838_d((Entity)cyclops);
            }
        }
    }

    protected boolean canSpawnAtCoords(WorldServer world, int chunkX, int chunkZ) {
        int l;
        int k;
        Random random;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.spacing - 1;
        }
        if ((random = world.func_72843_D(k = chunkX / this.spacing, l = chunkZ / this.spacing, 10387318)).nextInt(2) == 0) {
            return false;
        }
        k *= this.spacing;
        l *= this.spacing;
        if (i == (k += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2) && j == (l += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2)) {
            return world.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 16, SPAWN_BIOMES);
        }
        return false;
    }
}

