/*
 * Decompiled with CFR 0.152.
 */
package net.tangotek.cyclopstek;

import com.leviathanstudio.craftstudio.client.animation.ClientAnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.CustomChannel;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import com.leviathanstudio.craftstudio.common.animation.InfoChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tangotek.cyclopstek.CyclopsTek;
import net.tangotek.cyclopstek.EntityAICharge;
import net.tangotek.cyclopstek.EntityAIChaseTarget;
import net.tangotek.cyclopstek.EntityAIEyeBeam;
import net.tangotek.cyclopstek.EntityAIGroundSlam;
import net.tangotek.cyclopstek.ModItems;
import net.tangotek.cyclopstek.ModSoundEvents;
import net.tangotek.cyclopstek.TekDataSerializers;
import net.tangotek.cyclopstek.client.HeadLookAnim;
import net.tangotek.cyclopstek.tickjob.TickJob;
import net.tangotek.cyclopstek.tickjob.TickJobQueue;

public class EntityCyclops
extends EntityMob
implements IAnimated {
    private static final DataParameter<String> ANIM_NAME = EntityDataManager.func_187226_a(EntityCyclops.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Vec3d> FOCUS_POS = EntityDataManager.func_187226_a(EntityCyclops.class, TekDataSerializers.VECTOR_3D);
    private static final DataParameter<Boolean> EYE_BEAM = EntityDataManager.func_187226_a(EntityCyclops.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static AnimationHandler animHandler = CyclopsTek.getNewAnimationHandler(EntityCyclops.class);
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
    private static final float REGEN_RATE = 3.0f;
    private Set<BlockPos> breakableBlocks = new HashSet<BlockPos>();
    protected List<AnimationTrigger> animTriggers = new ArrayList<AnimationTrigger>();
    private int idleTicks;
    private boolean isWalking;
    private float aggroMult = 1.0f;
    private Map<UUID, Float> aggroTracker = new HashMap<UUID, Float>();
    private MovementMode lastMovementMode = null;
    private final TickJobQueue jobQueue = new TickJobQueue();

    public EntityCyclops(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.25f, 4.5f);
        this.field_70728_aV = 100;
        if (!this.field_70170_p.field_72995_K) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.field_70178_ae = true;
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        Runnable footStep = () -> {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.cyclopsStep, SoundCategory.HOSTILE, 1.2f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f, false);
            this.dustParticles(this.func_174791_d(), 20, 0.0f, this.field_70130_N);
        };
        this.addAnimationTrigger("cyclopstek:cyclops_walk", 9, footStep);
        this.addAnimationTrigger("cyclopstek:cyclops_walk", 55, footStep);
        this.addAnimationTrigger("cyclopstek:cyclops_ground_slam", 1, () -> this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.cyclopsPrep, SoundCategory.HOSTILE, 1.2f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f, false));
        this.addAnimationTrigger("cyclopstek:cyclops_ground_slam", 66, () -> this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.cyclopsGrunt, SoundCategory.HOSTILE, 1.2f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f, false));
        this.addAnimationTrigger("cyclopstek:cyclops_ground_slam", 78, () -> {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.groundImpact, SoundCategory.HOSTILE, 2.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f, false);
            this.dustParticles(this.getFocusPos(), 90, this.func_70681_au().nextFloat(), EntityAIGroundSlam.getSlamRadius(this.field_70170_p));
        });
        this.addAnimationTrigger("cyclopstek:cyclops_charge_prep", 1, () -> this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.cyclopsShout, SoundCategory.HOSTILE, 2.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f, false));
        this.addAnimationTrigger("cyclopstek:cyclops_eye_beam", 1, () -> this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.cyclopsBeamPrep, SoundCategory.HOSTILE, 2.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f, false));
        this.addAnimationTrigger("cyclopstek:cyclops_eye_beam", 30, () -> {
            Vec3d focusPos = this.getFocusPos();
            this.field_70170_p.func_184134_a(focusPos.field_72450_a, focusPos.field_72448_b, focusPos.field_72449_c, ModSoundEvents.cyclopsBeamBurn, SoundCategory.HOSTILE, 1.0f, this.field_70146_Z.nextFloat() * 0.6f + 0.7f, false);
        });
        this.addAnimationTrigger("cyclopstek:cyclops_eye_beam", 59, () -> this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.cyclopsEyeBeam, SoundCategory.HOSTILE, 2.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f, false));
        this.addJob(new TickJob(40, 80, true, () -> {
            if (this.isIdle() && this.func_70681_au().nextInt(2) == 0) {
                this.playSound(ModSoundEvents.cyclopsIdle);
            }
        }));
        this.addJob(new TickJob(80, 0, true, () -> this.aggroMult += 0.05f));
        this.addJob(new TickJob(80, 90, true, () -> this.breakBlocks(this.func_180425_c().func_177982_a(-3, -1, -3), this.func_180425_c().func_177982_a(3, 5, 3))));
        this.addJob(new TickJob(20, 20, true, () -> this.regen()));
    }

    public void dustParticles(Vec3d pos, int count, float extraY, float diameter) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)pos.field_72450_a);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i, j = MathHelper.func_76128_c((double)(pos.field_72448_b - 0.2)), k = MathHelper.func_76128_c((double)pos.field_72449_c)));
        if (iblockstate.func_185904_a() != Material.field_151579_a) {
            for (int n = 0; n < count; ++n) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, pos.field_72450_a + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)diameter, pos.field_72448_b + 0.1, pos.field_72449_c + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)diameter, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5 + (double)extraY, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        }
    }

    public void addJob(TickJob job) {
        this.jobQueue.addJob(job);
    }

    public void onAddedToWorld() {
        if (!this.field_70170_p.field_72995_K) {
            this.debugOut("onAddedToWorld " + this.func_70661_as());
            this.playClientAnimation("cyclops_custom_head_look");
        }
        super.onAddedToWorld();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.field_70180_af.func_187227_b(ANIM_NAME, (Object)"");
        this.field_70180_af.func_187227_b(EYE_BEAM, (Object)false);
        this.field_70180_af.func_187227_b(FOCUS_POS, (Object)Vec3d.field_186680_a);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANIM_NAME, (Object)"");
        this.field_70180_af.func_187214_a(EYE_BEAM, (Object)false);
        this.field_70180_af.func_187214_a(FOCUS_POS, (Object)Vec3d.field_186680_a);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEyeBeam(this, 30.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIGroundSlam(this, 5.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAICharge(this, 20.0, 1.5));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAIChaseTarget(this, 1.0, 4.0f));
        this.field_70714_bg.func_75776_a(20, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 40));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, p -> this.func_70638_az() == null));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.isWorldRemote() && ANIM_NAME.equals(key)) {
            this.updateClientAnim((String)this.field_70180_af.func_187225_a(ANIM_NAME));
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public Vec3d getFocusPos() {
        return (Vec3d)this.field_70180_af.func_187225_a(FOCUS_POS);
    }

    public void setFocusPos(Vec3d v) {
        this.field_70180_af.func_187227_b(FOCUS_POS, (Object)v);
    }

    public void setEyeBeam(boolean active) {
        this.field_70180_af.func_187227_b(EYE_BEAM, (Object)active);
    }

    public boolean isEyeBeamActive() {
        return (Boolean)this.field_70180_af.func_187225_a(EYE_BEAM);
    }

    public boolean isAnimationActive(String animName) {
        return ((String)this.field_70180_af.func_187225_a(ANIM_NAME)).equals(animName);
    }

    public boolean isAnimating() {
        return !((String)this.field_70180_af.func_187225_a(ANIM_NAME)).isEmpty();
    }

    public void stopServerAnimation(String anim) {
        this.field_70180_af.func_187227_b(ANIM_NAME, (Object)"");
    }

    public void playServerAnimation(String anim) {
        this.field_70180_af.func_187227_b(ANIM_NAME, (Object)anim);
    }

    public void debugOut(String text) {
        System.out.println(((Object)((Object)this)).getClass().getSimpleName() + "|" + this.func_145748_c_().func_150254_d() + "|" + this.func_145782_y() + " " + (text.charAt(0) == ' ' ? text : " " + text));
    }

    public void playSound(SoundEvent soundEvent) {
        this.func_184185_a(soundEvent, this.func_70681_au().nextFloat() * 0.4f + 0.8f, this.func_70681_au().nextFloat() * 0.4f + 0.8f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.func_70681_au().nextBoolean()) {
            return ModSoundEvents.cyclopsPain;
        }
        return null;
    }

    protected float func_70599_aP() {
        return 1.8f;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.cyclopsDeath;
    }

    protected SoundEvent func_184639_G() {
        return ModSoundEvents.cyclopsIdle;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return ModSoundEvents.groundImpact;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        EntityItem entityitem = this.func_145779_a(ModItems.cyclopsEye, 1);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
    }

    public void func_70642_aH() {
        if (this.func_70638_az() == null) {
            super.func_70642_aH();
        }
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70110_aj() {
    }

    protected void regen() {
        if (this.func_70089_S()) {
            this.func_70606_j(this.func_110143_aJ() + 3.0f);
        }
    }

    public void breakBlocks(BlockPos corner1, BlockPos corner2) {
        boolean anyBroken = false;
        if (!this.breakableBlocks.isEmpty()) {
            for (BlockPos bp : BlockPos.func_177975_b((BlockPos)corner1, (BlockPos)corner2)) {
                IBlockState blockState = this.field_70170_p.func_180495_p(bp);
                Block block = blockState.func_177230_c();
                if (block.isAir(blockState, (IBlockAccess)this.field_70170_p, bp) || !block.canEntityDestroy(blockState, (IBlockAccess)this.field_70170_p, bp, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)bp, (IBlockState)blockState) || !this.breakableBlocks.remove(bp)) continue;
                anyBroken = this.field_70170_p.func_175655_b(bp, true) || anyBroken;
            }
            if (anyBroken) {
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1022, new BlockPos((Entity)this), 0);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.jobQueue.tick();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.field_70170_p.field_72995_K) {
            this.idleTicks = this.field_70142_S == this.field_70165_t && this.field_70136_U == this.field_70161_v && this.field_70137_T == this.field_70163_u ? ++this.idleTicks : 0;
            boolean bl = this.isWalking = this.idleTicks <= 1;
            if (this.isWalking && this.field_70122_E) {
                this.startWalking();
            } else {
                this.stopWalking();
            }
            this.getAnimationHandler().animationsUpdate((IAnimated)this);
            this.checkAnimationTriggers();
        }
        if (!this.field_70170_p.field_72995_K) {
            Vec3d focus = this.getFocusPos();
            if (focus != Vec3d.field_186680_a) {
                this.func_70671_ap().func_75650_a(focus.field_72450_a, focus.field_72448_b, focus.field_72449_c, 20.0f, 20.0f);
            } else if (this.func_70638_az() != null) {
                Vec3d lookPos = this.func_70638_az().func_174791_d();
                this.func_70671_ap().func_75650_a(lookPos.field_72450_a, lookPos.field_72448_b, lookPos.field_72449_c, 20.0f, 20.0f);
            }
        }
    }

    public void faceLocation(double x, double z, float maxYawChange) {
        double dx = x - this.field_70165_t;
        double dz = z - this.field_70161_v;
        float f = (float)(MathHelper.func_181159_b((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        this.field_70759_as = this.field_70177_z = this.updateRotation(this.field_70177_z, f, maxYawChange);
        this.field_70761_aq = this.field_70177_z;
    }

    private float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public float func_70047_e() {
        return 4.125f;
    }

    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    private void addAggro(EntityLivingBase source, float amount) {
        float newAggro = this.aggroTracker.getOrDefault(source.func_110124_au(), Float.valueOf(0.0f)).floatValue() + amount * this.aggroMult;
        this.aggroTracker.put(source.func_110124_au(), Float.valueOf(newAggro));
        if (this.func_70638_az() == null) {
            this.func_70624_b(source);
        } else {
            float targetAggro = this.aggroTracker.getOrDefault(this.func_70638_az().func_110124_au(), Float.valueOf(0.0f)).floatValue();
            if (newAggro > targetAggro) {
                this.func_70624_b(source);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean result;
        if (source.func_76364_f() instanceof EntityArrow) {
            amount *= 0.65f;
        }
        if ((result = super.func_70097_a(source, amount)) && source.func_76346_g() instanceof EntityLivingBase) {
            this.addAggro((EntityLivingBase)source.func_76346_g(), amount);
        }
        return result;
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(WorldEvent.PotentialSpawns event) {
        if (this.func_174818_b(event.getPos()) < 1600.0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.PlaceEvent event) {
        BlockPos bp;
        if (!event.getWorld().field_72995_K && event.getPlacedBlock().func_177230_c().func_149703_v() && event.getBlockSnapshot().getDimId() == this.getDimension() && (bp = event.getBlockSnapshot().getPos()).func_177951_i((Vec3i)this.func_180425_c()) < 2500.0) {
            this.breakableBlocks.add(event.getBlockSnapshot().getPos());
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    protected boolean isWalking() {
        return this.isWalking;
    }

    public MovementMode getMovementMode() {
        return MovementMode.WALK;
    }

    @SideOnly(value=Side.CLIENT)
    protected void startWalking() {
        MovementMode mode = this.getMovementMode();
        if (mode != this.lastMovementMode) {
            if (this.lastMovementMode != null) {
                this.stopWalking();
            }
            this.lastMovementMode = mode;
            if (mode != null) {
                this.playClientAnimation(mode.anim);
            }
        }
        this.stopClientAnimation("cyclops_idle");
    }

    @SideOnly(value=Side.CLIENT)
    protected void stopWalking() {
        if (this.lastMovementMode != null) {
            this.stopClientAnimation(this.lastMovementMode.anim);
            this.lastMovementMode = null;
            if (!this.isAnimating()) {
                this.playClientAnimation("cyclops_idle");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        if (this.isEyeBeamActive()) {
            return this.func_174813_aQ().func_111270_a(new AxisAlignedBB(this.getFocusPos(), this.getFocusPos()));
        }
        return this.func_174813_aQ();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateClientAnim(String newAnim) {
        ClientAnimationHandler clientAnim = (ClientAnimationHandler)this.getAnimationHandler();
        Set animKeys = clientAnim.getAnimChannels().keySet();
        animKeys.forEach(a -> clientAnim.stopAnimation(a, (IAnimated)this));
        if (!newAnim.isEmpty()) {
            clientAnim.startAnimation("cyclopstek", newAnim, (IAnimated)this);
        } else if (!this.isWalking()) {
            this.playClientAnimation("cyclops_idle");
        }
        this.playClientAnimation("cyclops_custom_head_look");
    }

    protected boolean isIdle() {
        return this.getAnimationHandler().isAnimationActive("cyclopstek", "cyclops_idle", (IAnimated)this);
    }

    protected void playClientAnimation(String anim) {
        if (!this.getAnimationHandler().isAnimationActive("cyclopstek", anim, (IAnimated)this)) {
            this.getAnimationHandler().startAnimation("cyclopstek", anim, (IAnimated)this);
        }
    }

    public void stopClientAnimation(String anim) {
        if (this.getAnimationHandler().isAnimationActive("cyclopstek", anim, (IAnimated)this)) {
            this.getAnimationHandler().stopAnimation("cyclopstek", anim, (IAnimated)this);
        }
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected void checkAnimationTriggers() {
        ClientAnimationHandler clientAnim = (ClientAnimationHandler)this.getAnimationHandler();
        Map animInfoMap = (Map)clientAnim.getCurrentAnimInfo().get((Object)this);
        if (animInfoMap != null) {
            for (Map.Entry animInfo : animInfoMap.entrySet()) {
                for (AnimationTrigger trigger : this.animTriggers) {
                    if (!trigger.name.equals(((InfoChannel)animInfo.getKey()).name)) continue;
                    trigger.update(((AnimationHandler.AnimInfo)animInfo.getValue()).currentFrame);
                }
            }
        }
    }

    public void addAnimationTrigger(String name, int keyFrame, Runnable callback) {
        if (this.field_70170_p.field_72995_K) {
            this.animTriggers.add(new AnimationTrigger(name, keyFrame, callback));
        }
    }

    public int getDimension() {
        return this.field_71093_bK;
    }

    public double getX() {
        return this.field_70165_t;
    }

    public double getY() {
        return this.field_70163_u;
    }

    public double getZ() {
        return this.field_70161_v;
    }

    public boolean isWorldRemote() {
        return this.field_70170_p.field_72995_K;
    }

    public AnimationHandler getAnimationHandler() {
        return animHandler;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    static {
        animHandler.addAnim("cyclopstek", "cyclops_walk", "cyclops", true);
        animHandler.addAnim("cyclopstek", "cyclops_idle", "cyclops", true);
        animHandler.addAnim("cyclopstek", "cyclops_charge_prep", "cyclops", false);
        animHandler.addAnim("cyclopstek", "cyclops_ground_slam", "cyclops", false);
        animHandler.addAnim("cyclopstek", "cyclops_eye_beam", "cyclops", false);
        animHandler.addAnim("cyclopstek", "cyclops_custom_head_look", (CustomChannel)new HeadLookAnim());
    }

    private class AnimationTrigger {
        protected String name;
        protected int keyFrame;
        protected Runnable callback;
        protected boolean triggered = false;
        private float lastFrame = 0.0f;

        public AnimationTrigger(String name, int keyFrame, Runnable callback) {
            this.name = name;
            this.keyFrame = keyFrame;
            this.callback = callback;
        }

        public void update(float curFrame) {
            if (curFrame < this.lastFrame) {
                this.triggered = false;
            }
            if (curFrame >= (float)this.keyFrame && !this.triggered) {
                this.triggered = true;
                this.callback.run();
            }
            this.lastFrame = curFrame;
        }
    }

    public static enum MovementMode {
        WALK(1, 1.0f, "cyclops_walk"),
        RUN(3, 1.4f, "cyclops_run");

        public float speedMult;
        public byte id;
        public String anim;

        private MovementMode(byte id, float mult, String anim) {
            this.speedMult = mult;
            this.id = id;
            this.anim = anim;
        }

        public static MovementMode valueOf(byte id) {
            for (MovementMode mode : MovementMode.values()) {
                if (mode.id != id) continue;
                return mode;
            }
            return null;
        }
    }
}

