/*
 * Decompiled with CFR 0.152.
 */
package net.tangotek.cyclopstek;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tangotek.cyclopstek.EntityCyclops;
import net.tangotek.cyclopstek.tickjob.TickJob;

public class EntityAIGroundSlam
extends EntityAIBase {
    private int abilityTick = 0;
    private final int WARM_UP_TIME = 26;
    private final int ABILITY_TICK_TIME = 46;
    private final int COOLDOWN = 70;
    private static final float SLAM_RADIUS = 3.0f;
    private final double attackRange;
    private Vec3d targetPos = null;
    protected final EntityCyclops cyclops;
    private long nextAttackTick = 0L;
    protected final Predicate<EntityLivingBase> targetEntitySelector;

    public EntityAIGroundSlam(EntityCyclops entityIn, double range) {
        this.func_75248_a(1);
        this.cyclops = entityIn;
        this.attackRange = range;
        this.targetEntitySelector = target -> {
            if (target == null || target == this.cyclops) {
                return false;
            }
            return !EntitySelectors.field_180132_d.apply(target) ? false : EntityAITarget.func_179445_a((EntityLiving)this.cyclops, (EntityLivingBase)target, (boolean)false, (boolean)false);
        };
    }

    public boolean func_75250_a() {
        if (this.cyclops.func_70638_az() != null && this.cyclops.func_70089_S()) {
            if (this.cyclops.field_70170_p.func_82737_E() < this.nextAttackTick) {
                return false;
            }
            return !(this.cyclops.func_70638_az().func_70068_e((Entity)this.cyclops) > this.attackRange * this.attackRange);
        }
        return false;
    }

    private List<EntityLivingBase> getTargets() {
        float slamRadius = EntityAIGroundSlam.getSlamRadius(this.cyclops.field_70170_p);
        List targets = this.cyclops.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(new BlockPos(this.targetPos)).func_186662_g((double)slamRadius), this.targetEntitySelector);
        targets.removeIf(t -> t.func_70092_e(this.targetPos.field_72450_a, this.targetPos.field_72448_b, this.targetPos.field_72449_c) > (double)(slamRadius * slamRadius));
        return targets;
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75249_e() {
        this.targetPos = this.cyclops.func_70638_az().func_174791_d();
        super.func_75249_e();
        this.tryAttack();
    }

    public static float getSlamRadius(World world) {
        return 3.0f + (float)world.func_175659_aa().func_151525_a() / 3.0f;
    }

    protected void tryAttack() {
        if (this.cyclops.func_70089_S()) {
            this.abilityTick = 46;
            this.nextAttackTick = this.cyclops.field_70170_p.func_82737_E() + 70L + (long)this.cyclops.func_70681_au().nextInt(40);
            this.cyclops.playServerAnimation("cyclops_ground_slam");
            this.cyclops.setFocusPos(this.targetPos);
            this.cyclops.func_70661_as().func_75499_g();
            this.cyclops.addJob(new TickJob(26, 0, false, () -> {
                if (this.cyclops.func_70089_S()) {
                    List<EntityLivingBase> hostiles = this.getTargets();
                    hostiles.forEach(e -> {
                        float slamRadius;
                        double distanceFromCenter = e.func_70011_f(this.targetPos.field_72450_a, this.targetPos.field_72448_b, this.targetPos.field_72449_c);
                        if (distanceFromCenter <= (double)(slamRadius = EntityAIGroundSlam.getSlamRadius(this.cyclops.field_70170_p))) {
                            double radSq = slamRadius * slamRadius;
                            double fallOff = 1.0 - distanceFromCenter * distanceFromCenter / radSq;
                            double knockback = 6.0 * fallOff;
                            float damage = 50.0f * (float)fallOff;
                            BlockPos targetBlock = new BlockPos(this.targetPos);
                            this.cyclops.breakBlocks(targetBlock.func_177963_a((double)(-slamRadius), -1.0, (double)(-slamRadius)), targetBlock.func_177963_a((double)slamRadius, 3.0, (double)slamRadius));
                            boolean flag = e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.cyclops), damage);
                            if (flag && knockback > 0.0) {
                                e.func_70653_a((Entity)this.cyclops, (float)knockback, (double)MathHelper.func_76126_a((float)(this.cyclops.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.cyclops.field_70177_z * ((float)Math.PI / 180)))));
                                e.field_70181_x += 1.0;
                            }
                        }
                    });
                }
            }));
        }
    }

    public void func_75246_d() {
        --this.abilityTick;
        super.func_75246_d();
    }

    public void func_75251_c() {
        this.cyclops.stopServerAnimation("cyclops_ground_slam");
        this.cyclops.setFocusPos(Vec3d.field_186680_a);
        this.abilityTick = 0;
        super.func_75251_c();
    }

    public boolean func_75253_b() {
        if (this.abilityTick > 0) {
            return true;
        }
        return super.func_75253_b();
    }
}

