/*
 * Decompiled with CFR 0.152.
 */
package net.tangotek.cyclopstek;

import com.google.common.base.Predicate;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.tangotek.cyclopstek.EntityCyclops;
import net.tangotek.cyclopstek.ModSoundEvents;
import net.tangotek.cyclopstek.tickjob.TickJob;

public class EntityAIEyeBeam
extends EntityAIBase {
    private int abilityTick = 0;
    private final int WARM_UP_TIME = 22;
    private final int BEAM_ACTIVE_TIME = 50;
    private final int ABILITY_TICK_TIME = 79;
    public static final double BEAM_CHASE_RATE = 0.23;
    private final int COOLDOWN = 200;
    public static final float IMPACT_RADIUS = 0.7f;
    private final double attackRange;
    private final DamageSource beamDamageSource;
    private Vec3d targetPos = null;
    private EntityLivingBase targetEntity = null;
    protected final EntityCyclops cyclops;
    private long nextAttackTick = 0L;
    private int beamAciveTick = 0;
    protected final Predicate<EntityLivingBase> targetEntitySelector;

    public EntityAIEyeBeam(EntityCyclops entityIn, double range) {
        this.func_75248_a(1);
        this.cyclops = entityIn;
        this.attackRange = range;
        this.beamDamageSource = new EntityDamageSourceIndirect("eye_beam", (Entity)this.cyclops, (Entity)this.cyclops).func_76348_h();
        this.targetEntitySelector = target -> {
            if (target == null || target == this.cyclops) {
                return false;
            }
            return !EntitySelectors.field_180132_d.apply(target) ? false : EntityAITarget.func_179445_a((EntityLiving)this.cyclops, (EntityLivingBase)target, (boolean)false, (boolean)true) && target.func_190631_cK();
        };
    }

    public boolean func_75250_a() {
        List targets;
        if (this.cyclops.func_70089_S() && this.cyclops.func_70681_au().nextInt(20) == 0 && !(targets = this.cyclops.field_70170_p.func_175647_a(EntityLivingBase.class, this.cyclops.func_174813_aQ().func_186662_g(this.attackRange), this.targetEntitySelector)).isEmpty()) {
            EntityLivingBase closest = targets.stream().min(Comparator.comparing(e -> e.func_70068_e((Entity)this.cyclops))).get();
            EntityLivingBase farthest = targets.stream().max(Comparator.comparing(e -> e.func_70068_e((Entity)this.cyclops))).get();
            if (farthest != null) {
                if (closest.func_70068_e((Entity)this.cyclops) > 100.0) {
                    this.nextAttackTick -= 20L;
                }
                if (this.cyclops.field_70170_p.func_82737_E() < this.nextAttackTick) {
                    return false;
                }
                this.targetEntity = farthest;
                this.targetPos = farthest.func_174791_d();
                return true;
            }
        }
        return false;
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.removeDebug();
        this.beginAim();
    }

    private float getImpactRadius() {
        return 0.7f;
    }

    private List<EntityLivingBase> getTargets(Vec3d pos) {
        Vec3d focusPos = this.cyclops.getFocusPos();
        List targets = this.cyclops.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(new BlockPos(focusPos)).func_186662_g((double)(this.getImpactRadius() + 1.0f)), this.targetEntitySelector);
        targets.removeIf(t -> t.func_70092_e(focusPos.field_72450_a, focusPos.field_72448_b, focusPos.field_72449_c) > (double)(this.getImpactRadius() * this.getImpactRadius()) || !t.func_70685_l((Entity)this.cyclops));
        return targets;
    }

    protected void beginAim() {
        if (this.cyclops.func_70089_S()) {
            this.abilityTick = 79;
            this.cyclops.playServerAnimation("cyclops_eye_beam");
            this.cyclops.setFocusPos(this.targetPos);
            this.cyclops.func_70661_as().func_75499_g();
            this.cyclops.addJob(new TickJob(22, 0, false, () -> this.fireLaser()));
        }
    }

    protected void fireLaser() {
        if (this.cyclops.func_70089_S()) {
            this.cyclops.setEyeBeam(true);
            this.beamAciveTick = 50;
        }
    }

    private void placeDebug(Vec3d pos) {
    }

    private void removeDebug() {
    }

    public void func_75246_d() {
        super.func_75246_d();
        --this.abilityTick;
        if (this.beamAciveTick > 0) {
            --this.beamAciveTick;
            if (this.beamAciveTick <= 0) {
                this.cyclops.setEyeBeam(false);
            }
            Vec3d delta = this.targetEntity.func_174791_d().func_178788_d(this.cyclops.getFocusPos());
            double chaseRate = 0.23 + 0.015 * (double)this.cyclops.field_70170_p.func_175659_aa().func_151525_a();
            Vec3d chase = delta.func_72432_b().func_186678_a(chaseRate);
            this.cyclops.setFocusPos(this.cyclops.getFocusPos().func_178787_e(chase));
            Vec3d focusPos = this.cyclops.getFocusPos();
            this.placeDebug(focusPos);
            BlockPos firePos = new BlockPos(focusPos);
            if (this.cyclops.field_70170_p.func_175623_d(firePos)) {
                this.cyclops.field_70170_p.func_175656_a(firePos, Blocks.field_150480_ab.func_176223_P());
            }
            if (this.cyclops.func_70089_S() && this.beamAciveTick % 8 == 0) {
                List<EntityLivingBase> hostiles = this.getTargets(focusPos);
                hostiles.forEach(e -> {
                    float damage = 6.0f;
                    AttributeModifier attributeModifier = new AttributeModifier("Eye Beam AntiKnock", 1.0, 0);
                    e.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(attributeModifier);
                    e.func_70097_a(this.beamDamageSource, damage);
                    e.func_184185_a(ModSoundEvents.cyclopsBeamFlare, e.func_70681_au().nextFloat() * 0.4f + 1.2f, e.func_70681_au().nextFloat() * 0.4f + 1.2f);
                    e.func_70015_d(5);
                    e.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(attributeModifier);
                });
            }
        }
    }

    public void func_75251_c() {
        this.cyclops.stopServerAnimation("cyclops_eye_beam");
        this.nextAttackTick = this.cyclops.field_70170_p.func_82737_E() + 200L + (long)this.cyclops.func_70681_au().nextInt(40);
        this.cyclops.setFocusPos(Vec3d.field_186680_a);
        this.cyclops.setEyeBeam(false);
        this.abilityTick = 0;
        this.beamAciveTick = 0;
        super.func_75251_c();
    }

    public boolean func_75253_b() {
        if (this.abilityTick > 0) {
            return true;
        }
        if (this.targetEntity == null || this.targetEntity.func_70089_S()) {
            return false;
        }
        return super.func_75253_b();
    }
}

