/*
 * Decompiled with CFR 0.152.
 */
package net.tangotek.cyclopstek;

import com.google.common.base.Predicate;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.Vec3d;
import net.tangotek.cyclopstek.EntityCyclops;
import net.tangotek.cyclopstek.ModSoundEvents;
import net.tangotek.cyclopstek.tickjob.TickJob;

public class EntityAICharge
extends EntityAIBase {
    private int abilityTick = 0;
    private final int WARM_UP_TIME = 20;
    private final int MAX_ABILITY_TICKS = 200;
    private final int COOLDOWN = 160;
    private final double attackRange;
    private final double speedModifier;
    private Vec3d targetPos = null;
    private EntityLivingBase targetEntity = null;
    protected final EntityCyclops cyclops;
    private long nextAttackTick = 0L;
    private boolean charging = false;
    protected final Predicate<EntityLivingBase> targetEntitySelector;
    public static final AttributeModifier speedAttribute = new AttributeModifier("Cyclops Charge", 0.4, 2).func_111168_a(false);

    public EntityAICharge(EntityCyclops entityIn, double range, double speedMod) {
        this.func_75248_a(1);
        this.cyclops = entityIn;
        this.attackRange = range;
        this.speedModifier = speedMod;
        this.targetEntitySelector = target -> {
            if (target == null) {
                return false;
            }
            return !EntitySelectors.field_180132_d.apply(target) ? false : EntityAITarget.func_179445_a((EntityLiving)this.cyclops, (EntityLivingBase)target, (boolean)false, (boolean)true);
        };
    }

    public boolean func_75250_a() {
        List targets;
        if (this.cyclops.func_70089_S() && this.cyclops.func_70681_au().nextInt(20) == 0 && !(targets = this.cyclops.field_70170_p.func_175647_a(EntityLivingBase.class, this.cyclops.func_174813_aQ().func_186662_g(this.attackRange), this.targetEntitySelector)).isEmpty()) {
            EntityLivingBase closest = targets.stream().min(Comparator.comparing(e -> e.func_70068_e((Entity)this.cyclops))).get();
            EntityLivingBase farthest = targets.stream().max(Comparator.comparing(e -> e.func_70068_e((Entity)this.cyclops))).get();
            if (farthest != null) {
                if (closest.func_70068_e((Entity)this.cyclops) > 49.0) {
                    this.nextAttackTick -= 20L;
                }
                if (this.cyclops.field_70170_p.func_82737_E() < this.nextAttackTick) {
                    return false;
                }
                if (farthest.func_70068_e((Entity)this.cyclops) > 49.0 && this.setChargePos(farthest)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean setChargePos(EntityLivingBase target) {
        if (target != null && target.func_70089_S()) {
            Vec3d pos = target.func_174791_d();
            Path path = this.cyclops.func_70661_as().func_75488_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            if (path != null) {
                this.targetPos = target.func_174791_d();
                this.targetEntity = target;
                return true;
            }
        }
        return false;
    }

    private List<EntityLivingBase> getTargets() {
        List targets = this.cyclops.field_70170_p.func_175647_a(EntityLivingBase.class, this.cyclops.func_174813_aQ().func_186662_g(1.5), this.targetEntitySelector);
        return targets;
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        System.out.println("Charge Start");
        this.cyclops.setFocusPos(this.targetPos);
        this.nextAttackTick = this.cyclops.field_70170_p.func_82737_E() + 160L + (long)this.cyclops.func_70681_au().nextInt(40);
        this.abilityTick = 200;
        this.cyclops.func_70661_as().func_75499_g();
        this.cyclops.playServerAnimation("cyclops_charge_prep");
        this.cyclops.playSound(ModSoundEvents.cyclopsShout);
        this.cyclops.addJob(new TickJob(20, 0, false, () -> this.startCharge()));
    }

    private void startCharge() {
        this.cyclops.stopServerAnimation("cyclops_charge_prep");
        this.setChargePos(this.targetEntity);
        boolean hasPath = this.cyclops.func_70661_as().func_75492_a(this.targetPos.field_72450_a, this.targetPos.field_72448_b, this.targetPos.field_72449_c, this.speedModifier);
        this.placeDebug();
        if (!hasPath) {
            System.out.println("Cyclops Charge: Path Failed");
        }
        if (this.func_75253_b()) {
            this.charging = true;
            this.cyclops.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(speedAttribute);
        }
    }

    public void func_75246_d() {
        --this.abilityTick;
        super.func_75246_d();
        if (this.charging && this.abilityTick % 2 == 0) {
            if (this.targetEntity != null && this.targetEntity.func_70089_S()) {
                this.cyclops.func_70625_a((Entity)this.targetEntity, 30.0f, 30.0f);
            }
            this.chargeEffect();
        }
    }

    private void chargeEffect() {
        this.cyclops.breakBlocks(this.cyclops.func_180425_c().func_177982_a(-3, -1, -3), this.cyclops.func_180425_c().func_177982_a(3, 5, 3));
        List<EntityLivingBase> targets = this.getTargets();
        targets.forEach(e -> {
            float knockback = 3.0f;
            float damage = 8.0f;
            boolean flag = e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.cyclops), damage);
            if (flag && knockback > 0.0f) {
                Vec3d dir = this.cyclops.func_174791_d().func_178788_d(e.func_174791_d()).func_72432_b();
                e.func_70653_a((Entity)this.cyclops, knockback, dir.field_72450_a, dir.field_72449_c);
                e.field_70181_x += 1.0;
            }
        });
    }

    public void func_75251_c() {
        this.removeDebug();
        this.cyclops.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(speedAttribute);
        this.cyclops.stopServerAnimation("cyclops_charge_prep");
        this.cyclops.setFocusPos(Vec3d.field_186680_a);
        this.abilityTick = 0;
        this.targetEntity = null;
        this.charging = false;
        super.func_75251_c();
    }

    public boolean func_75253_b() {
        if (this.cyclops.func_70092_e(this.targetPos.field_72450_a, this.targetPos.field_72448_b, this.targetPos.field_72449_c) < 2.0) {
            this.chargeEffect();
            return false;
        }
        if (this.charging && !this.cyclops.func_70781_l()) {
            return false;
        }
        return this.abilityTick > 0;
    }

    private void placeDebug() {
    }

    private void removeDebug() {
    }
}

