/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.lemonlib.ticker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import party.lemons.lemonlib.ticker.ITicker;
import party.lemons.lemonlib.ticker.TickerSavedData;

@Mod.EventBusSubscriber(modid="lemonlib")
public class TickerHandler {
    private static HashMap<Integer, List<ITicker>> worldTickers = new HashMap();
    private static List<Class<ITicker>> registeredTickers = new ArrayList<Class<ITicker>>();

    public static void addTicker(ITicker ticker, int dim) {
        if (!worldTickers.containsKey(dim)) {
            worldTickers.put(dim, new ArrayList());
        }
        if (ticker.isUnique() && TickerHandler.hasTickerOfType(dim, ticker.getClass())) {
            return;
        }
        worldTickers.get(dim).add(ticker);
    }

    private static boolean hasTickerOfType(int dim, Class<? extends ITicker> clazz) {
        if (!worldTickers.containsKey(dim)) {
            return false;
        }
        return worldTickers.get(dim).stream().anyMatch(t -> t.getClass() == clazz);
    }

    private static void removeFinishedTickers(World world) {
        for (List<ITicker> tickerList : worldTickers.values()) {
            tickerList.removeIf(t -> t.isTaskFinished(world));
        }
    }

    private static void tick(World world) {
        if (!worldTickers.containsKey(world.field_73011_w.getDimension())) {
            return;
        }
        List<ITicker> tickerList = worldTickers.get(world.field_73011_w.getDimension());
        tickerList.stream().forEach(t -> t.update(world));
    }

    public static <T extends ITicker> void registerTicker(Class<T> clazz) {
        registeredTickers.add(clazz);
    }

    public static NBTTagList writeToNBT() {
        NBTTagList list = new NBTTagList();
        for (List<ITicker> tickerList : worldTickers.values()) {
            for (ITicker ticker : tickerList) {
                NBTTagCompound tickerTags = ticker.writeToNBT();
                tickerTags.func_74768_a("key", registeredTickers.indexOf(ticker.getClass()));
                tickerTags.func_74768_a("dim", ticker.getDimension());
                list.func_74742_a((NBTBase)tickerTags);
            }
        }
        return list;
    }

    public static void readFromNBT(NBTTagList tickerList) {
        worldTickers.clear();
        World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
        for (int i = 0; i < tickerList.func_74745_c(); ++i) {
            NBTTagCompound tag = tickerList.func_150305_b(i);
            Class<ITicker> clazz = registeredTickers.get(tag.func_74762_e("key"));
            int dimID = tag.func_74762_e("dim");
            try {
                ITicker ticker = clazz.getConstructor(World.class).newInstance(world);
                ticker.readFromNBT(tag);
                TickerHandler.addTicker(ticker, dimID);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        TickerHandler.tick(event.world);
        TickerHandler.removeFinishedTickers(event.world);
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        TickerSavedData.get(event.getWorld());
    }
}

