/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.processing.churn.user;

import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.config.AbstractUserJSONConfig;
import growthcraft.core.shared.config.schema.FluidStackSchema;
import growthcraft.core.shared.config.schema.ItemKeySchema;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.processing.churn.IChurnRecipe;
import growthcraft.milk.shared.processing.churn.user.UserChurnRecipe;
import growthcraft.milk.shared.processing.churn.user.UserChurnRecipes;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UserChurnRecipesConfig
extends AbstractUserJSONConfig {
    private final UserChurnRecipes defaultRecipes = new UserChurnRecipes();
    private UserChurnRecipes recipes;

    public void addDefault(UserChurnRecipe recipe) {
        this.defaultRecipes.data.add(recipe);
    }

    public void addDefault(FluidStack inp, FluidStack out, ItemStack stack, int churns) {
        this.addDefault(new UserChurnRecipe(new FluidStackSchema(inp), new FluidStackSchema(out), new ItemKeySchema(stack), churns));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserChurnRecipes)this.gson.fromJson((Reader)reader, UserChurnRecipes.class);
    }

    private void addChurnRecipe(UserChurnRecipe recipe) {
        if (recipe == null) {
            GrowthcraftLogger.getLogger("growthcraft_milk").error("Invalid recipe");
            return;
        }
        if (recipe.input_fluid == null || recipe.input_fluid.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_milk").error("Invalid input_fluid {%s}", (Object)recipe);
            return;
        }
        for (IChurnRecipe churnRecipe : recipe.toChurnRecipes()) {
            GrowthcraftLogger.getLogger("growthcraft_milk").debug("Adding user churn recipe {%s}", (Object)churnRecipe);
            MilkRegistry.instance().churn().addRecipe(churnRecipe);
        }
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                GrowthcraftLogger.getLogger("growthcraft_milk").debug("Adding %d user brewing recipes.", (Object)this.recipes.data.size());
                for (UserChurnRecipe recipe : this.recipes.data) {
                    this.addChurnRecipe(recipe);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft_milk").error("Recipes data is invalid!");
            }
        }
    }
}

