/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.cheese;

import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.definition.ICheeseType;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class CheeseIO {
    private CheeseIO() {
    }

    public static ICheeseType loadFromStream(ByteBuf stream) {
        int id = stream.readInt();
        return MilkRegistry.instance().cheese().getSafeCheeseById(id);
    }

    public static boolean writeToStream(ByteBuf stream, ICheeseType type) {
        stream.writeInt(MilkRegistry.instance().cheese().getCheeseId(type));
        return false;
    }

    public static ICheeseType loadFromNBT(NBTTagCompound nbt) {
        String modId = nbt.func_74779_i("cheese_modid");
        String name = nbt.func_74779_i("cheese_name");
        return MilkRegistry.instance().cheese().getSafeCheeseByName(new ResourceLocation(modId, name));
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound tag, ICheeseType type) {
        ResourceLocation name = type.getRegistryName();
        tag.func_74778_a("cheese_modid", name.func_110624_b());
        tag.func_74778_a("cheese_name", name.func_110623_a());
        return tag;
    }
}

