/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity.device;

import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.component.TileHeatingComponent;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import growthcraft.milk.shared.processing.cheesevat.ICheeseVatRecipe;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class CheeseVat
extends DeviceProgressive<ICheeseVatRecipe> {
    private DeviceFluidSlot primaryFluidSlot;
    private DeviceFluidSlot rennetFluidSlot;
    private DeviceFluidSlot wasteFluidSlot;
    private TileHeatingComponent heatComponent;

    public CheeseVat(GrowthcraftTileDeviceBase te, int primFluidSlot_id, int rennetFluidSlot_id, int wasteFluidSlot_id) {
        super(te);
        this.primaryFluidSlot = new DeviceFluidSlot(te, primFluidSlot_id);
        this.rennetFluidSlot = new DeviceFluidSlot(te, rennetFluidSlot_id);
        this.wasteFluidSlot = new DeviceFluidSlot(te, wasteFluidSlot_id);
        this.heatComponent = new TileHeatingComponent(te, 0.5f);
    }

    public CheeseVat setHeatMultiplier(float h) {
        this.heatComponent.setHeatMultiplier(h);
        return this;
    }

    public float getHeatMultiplier() {
        return this.heatComponent.getHeatMultiplier();
    }

    public boolean isHeated() {
        return this.getHeatMultiplier() > 0.0f;
    }

    @Override
    protected ICheeseVatRecipe loadRecipe() {
        return null;
    }

    @Override
    protected boolean canProcess() {
        ICheeseVatRecipe recipe = (ICheeseVatRecipe)this.getWorkingRecipe();
        return recipe != null;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.heatComponent.readFromNBT(data, "heat_component");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.heatComponent.writeToNBT(data, "heat_component");
    }

    @Override
    public boolean readFromStream(ByteBuf buf) {
        super.readFromStream(buf);
        this.heatComponent.readFromStream(buf);
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf buf) {
        super.writeToStream(buf);
        this.heatComponent.writeToStream(buf);
        return false;
    }
}

