/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.core.shared.inventory.GrowthcraftInternalInventory;
import growthcraft.core.shared.item.ItemTest;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.IItemOperable;
import growthcraft.core.shared.tileentity.feature.ITileProgressiveDevice;
import growthcraft.milk.common.item.ItemBlockHangingCurds;
import growthcraft.milk.common.tileentity.device.CheesePress;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCheesePress
extends GrowthcraftTileDeviceBase
implements ITickable,
IItemOperable,
ITileProgressiveDevice {
    private static int[][] accessibleSlots = new int[][]{{0}, {0}, {0}, {0}, {0}, {0}};
    @SideOnly(value=Side.CLIENT)
    public float animProgress;
    @SideOnly(value=Side.CLIENT)
    public int animDir;
    private int screwState;
    private DeviceInventorySlot invSlot = new DeviceInventorySlot((IInventory)this, 0);
    private final CheesePress cheesePress = new CheesePress(this);

    @Override
    public DeviceBase[] getDevices() {
        return new DeviceBase[]{this.cheesePress};
    }

    @Override
    public float getDeviceProgress() {
        return this.cheesePress.getProgress();
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        return this.cheesePress.getProgressScaled(scale);
    }

    public boolean isPressed() {
        return this.screwState == 1;
    }

    public boolean isUnpressed() {
        return this.screwState == 0;
    }

    public boolean isAnimating() {
        return this.animProgress > 0.0f && this.animProgress < 1.0f;
    }

    @Override
    public void onInventoryChanged(IInventory inv, int index) {
        super.onInventoryChanged(inv, index);
        this.cheesePress.markForRecipeRecheck();
    }

    @Override
    public GrowthcraftInternalInventory createInventory() {
        return new GrowthcraftInternalInventory(this, 1, 1);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grcmilk.CheesePress";
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemstack) {
        return true;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return accessibleSlots[side.ordinal()];
    }

    @Override
    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        return this.isUnpressed() && index == 0;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return this.isUnpressed() && index == 0;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateEntityClient() {
        float step = 0.05f;
        int prevAnimDir = this.animDir;
        this.animDir = this.isUnpressed() ? 1 : -1;
        if (this.animDir > 0 && this.animProgress < 1.0f || this.animDir < 0 && this.animProgress > 0.0f) {
            this.animProgress = MathHelper.func_76131_a((float)(this.animProgress + 0.05f * (float)this.animDir), (float)0.0f, (float)1.0f);
        }
    }

    private void updateEntityServer() {
        this.cheesePress.update();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
        } else {
            this.updateEntityServer();
        }
    }

    public boolean toggle(boolean state) {
        int oldScrewState = this.screwState;
        int n = this.screwState = state ? 1 : 0;
        if (oldScrewState != this.screwState) {
            this.markDirtyAndUpdate(true);
        }
        return oldScrewState != this.screwState;
    }

    public boolean toggle() {
        return this.toggle(this.screwState == 0);
    }

    @Override
    public boolean tryPlaceItem(IItemOperable.Action action, EntityPlayer player, ItemStack stack) {
        ItemBlockHangingCurds item;
        if (IItemOperable.Action.RIGHT != action) {
            return false;
        }
        if (ItemTest.isValid(stack) && this.invSlot.isEmpty() && this.isUnpressed() && stack.func_77973_b() instanceof ItemBlockHangingCurds && (item = (ItemBlockHangingCurds)stack.func_77973_b()).isDried(stack)) {
            ItemStack result = ItemUtils.decrPlayerCurrentInventorySlot(player, 1);
            this.invSlot.set(result);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryTakeItem(IItemOperable.Action action, EntityPlayer player, ItemStack onHand) {
        ItemStack result;
        if (IItemOperable.Action.RIGHT != action) {
            return false;
        }
        if (!player.func_70093_af()) {
            return false;
        }
        if (this.isUnpressed() && !ItemUtils.isEmpty(result = this.invSlot.yank())) {
            ItemUtils.spawnItemStackAtTile(result, this, this.field_145850_b.field_73012_v);
            return true;
        }
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_CheesePress(NBTTagCompound nbt) {
        this.screwState = nbt.func_74762_e("screw_state");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_CheesePress(NBTTagCompound nbt) {
        nbt.func_74768_a("screw_state", this.screwState);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_CheesePress(ByteBuf stream) throws IOException {
        this.screwState = stream.readInt();
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_CheesePress(ByteBuf stream) throws IOException {
        stream.writeInt(this.screwState);
        return false;
    }
}

