/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.hops.common.block;

import growthcraft.core.shared.block.BlockCheck;
import growthcraft.core.shared.block.IBlockRope;
import growthcraft.core.shared.block.ICropDataProvider;
import growthcraft.core.shared.init.GrowthcraftCoreBlocks;
import growthcraft.core.shared.init.GrowthcraftCoreItems;
import growthcraft.hops.shared.config.GrowthcraftHopsConfig;
import growthcraft.hops.shared.init.GrowthcraftHopsItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHops
extends BlockBush
implements IBlockRope,
IPlantable,
ICropDataProvider,
IGrowable {
    private final int hopVineMaxYield = GrowthcraftHopsConfig.hopVineMaxYield;
    private final float hopVineGrowthRate = GrowthcraftHopsConfig.hopVineGrowthRate;
    private final float hopVineFlowerSpawnRate = GrowthcraftHopsConfig.hopVineFlowerSpawnRate;
    private static final AxisAlignedBB BOUNDING_BINE = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.3125, 0.625);
    private static final AxisAlignedBB BOUNDING_SMALL = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB BOUNDING_BIG = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    public static final PropertyBool OPAQUEBELOW = PropertyBool.func_177716_a((String)"opaquebelow");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private static Random rand = new Random();

    public BlockHops(String unlocalizedName) {
        super(Material.field_151585_k);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_hops", unlocalizedName));
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)OPAQUEBELOW, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int age = this.getAge(state);
        switch (age) {
            case 0: {
                return BOUNDING_BINE;
            }
            case 1: {
                return BOUNDING_SMALL;
            }
        }
        return BOUNDING_BIG;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        int age = this.getAge(state);
        if (age > 0) {
            BlockHops.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState other = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = other.func_177230_c();
        return block != this || this.getAge(blockState) < 2 || this.getAge(other) < 2;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!this.isSupported(worldIn, pos, state)) {
            worldIn.func_175656_a(pos, GrowthcraftCoreBlocks.rope_fence.getDefaultState());
            List drops = super.getDrops((IBlockAccess)worldIn, pos, state, 0);
            for (ItemStack drop : drops) {
                BlockHops.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        } else if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
            this.func_176474_b(worldIn, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public boolean isMature(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.getAge(state) >= 3;
    }

    @Override
    public float getGrowthProgress(IBlockAccess world, BlockPos pos, IBlockState state) {
        return (float)this.getAge(state) / 3.0f;
    }

    protected void incrementGrowth(World world, BlockPos pos, IBlockState state) {
        int nextAge = this.getAge(state) + 1;
        if (nextAge <= 3) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(nextAge)), 2);
        }
    }

    public void spreadLeaves(World world, BlockPos pos) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)), 3);
    }

    public boolean canSpreadLeaves(World world, BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        IBlockState upState = world.func_180495_p(up);
        return BlockCheck.isRope(upState.func_177230_c()) && this.isSupported(world, up, upState);
    }

    private float getGrowthRateLoop(World world, BlockPos pos, IBlockState state) {
        if (BlockCheck.canSustainPlant((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this)) {
            return this.getGrowthRate(world, pos);
        }
        for (int loop = 1; loop < 5; ++loop) {
            BlockPos dwn = pos.func_177979_c(loop);
            IBlockState dwnState = world.func_180495_p(dwn);
            if (dwnState.func_177230_c() != this) {
                return this.getGrowthRate(world, pos);
            }
            if (!this.isVineRoot(world, dwn, dwnState)) continue;
            return this.getGrowthRate(world, dwn);
        }
        return this.getGrowthRate(world, pos);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return this.getAge(state) < 3 || this.canSpreadLeaves(worldIn, pos);
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        Event.Result allowGrowthResult = Event.Result.DEFAULT;
        if (allowGrowthResult == Event.Result.DENY) {
            return;
        }
        int age = this.getAge(state);
        float f = this.getGrowthRateLoop(worldIn, pos, state);
        if (age < 2) {
            if (allowGrowthResult == Event.Result.ALLOW || rand.nextInt((int)(this.hopVineGrowthRate / f) + 1) == 0) {
                this.incrementGrowth(worldIn, pos, state);
            }
        } else if (age >= 2 && this.canSpreadLeaves(worldIn, pos)) {
            if (allowGrowthResult == Event.Result.ALLOW || rand.nextInt((int)(this.hopVineGrowthRate / f) + 1) == 0) {
                this.spreadLeaves(worldIn, pos);
            }
        } else if (allowGrowthResult == Event.Result.ALLOW || rand.nextInt((int)(this.hopVineFlowerSpawnRate / f) + 1) == 0) {
            this.incrementGrowth(worldIn, pos, state);
        }
    }

    private float getGrowthRate(World world, BlockPos pos) {
        return BlockCrops.func_180672_a((Block)this, (World)world, (BlockPos)pos);
    }

    public void removeFruit(World world, BlockPos pos, IBlockState state) {
        if (this.getAge(state) >= 3) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)), 3);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.getAge(state) >= 3) {
            if (!worldIn.field_72995_K) {
                this.removeFruit(worldIn, pos, state);
                this.dropFruitAsItemWithChance(worldIn, this.getAdjacentBlockPosToPlayer(pos, playerIn), state, 1.0f, 0);
            }
            return true;
        }
        return false;
    }

    private void dropFruitAsItemWithChance(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (this.getAge(state) < 3) {
            return;
        }
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots && worldIn.field_73012_v.nextFloat() <= chance) {
            BlockHops.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getFruitDrop(fortune));
        }
    }

    private BlockPos getAdjacentBlockPosToPlayer(BlockPos pos, EntityPlayer playerIn) {
        BlockPos playerBlock = playerIn.func_180425_c();
        int offsX = 0;
        if (pos.func_177958_n() > playerBlock.func_177958_n()) {
            offsX = -1;
        } else if (pos.func_177958_n() < playerBlock.func_177958_n()) {
            offsX = 1;
        }
        int offsZ = 0;
        if (pos.func_177952_p() > playerBlock.func_177952_p()) {
            offsZ = -1;
        } else if (pos.func_177952_p() < playerBlock.func_177952_p()) {
            offsZ = 1;
        }
        return pos.func_177965_g(offsX).func_177970_e(offsZ);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == this || state.func_177230_c() == Blocks.field_150458_ak;
    }

    public boolean isSupported(World world, BlockPos pos, IBlockState state) {
        if (BlockCheck.canSustainPlant((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this)) {
            return true;
        }
        for (int loop = 1; loop < 5; ++loop) {
            BlockPos dwn = pos.func_177979_c(loop);
            IBlockState dwnState = world.func_180495_p(dwn);
            if (dwnState.func_177230_c() != this) {
                return false;
            }
            if (!this.isVineRoot(world, dwn, dwnState)) continue;
            return true;
        }
        return false;
    }

    private boolean isVineRoot(World world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() == this && BlockCheck.canSustainPlant((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this) && this.getAge(state) >= 2;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return this.getAge(state) < 3 ? GrowthcraftHopsItems.hop_seeds.asStack() : GrowthcraftHopsItems.hops.asStack();
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean canConnectRopeTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block instanceof IBlockRope;
    }

    @Override
    public boolean canRopeBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block == GrowthcraftCoreBlocks.rope_fence.getBlock() || block == GrowthcraftCoreBlocks.rope_knot.getBlock();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(GrowthcraftCoreItems.rope.asStack(1));
        int age = this.getAge(state);
        if (age >= 2) {
            drops.add(this.getFruitDrop(fortune));
        }
        if (age == 0 || rand.nextInt(3) == 0) {
            drops.add(GrowthcraftHopsItems.hop_seeds.asStack(1));
        }
        return drops;
    }

    public ItemStack getFruitDrop(int fortune) {
        return GrowthcraftHopsItems.hops.asStack(1 + rand.nextInt(this.hopVineMaxYield));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, NORTH, EAST, SOUTH, WEST, UP, DOWN, OPAQUEBELOW});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta & 3));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= (Integer)state.func_177229_b((IProperty)AGE) & 3;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState stateBelow = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177226_a((IProperty)OPAQUEBELOW, (Comparable)Boolean.valueOf(stateBelow.func_185914_p())).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.WEST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.DOWN)));
    }

    public static class HopsStage {
        public static final int BINE = 0;
        public static final int SMALL = 1;
        public static final int BIG = 2;
        public static final int FRUIT = 3;

        private HopsStage() {
        }
    }
}

