/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.grapes.common.blocks;

import growthcraft.core.shared.block.BlockCheck;
import growthcraft.core.shared.block.IBlockRope;
import growthcraft.core.shared.init.GrowthcraftCoreBlocks;
import growthcraft.core.shared.init.GrowthcraftCoreItems;
import growthcraft.grapes.common.blocks.BlockGrapeFruit;
import growthcraft.grapes.common.blocks.BlockGrapeVine1;
import growthcraft.grapes.common.blocks.BlockGrapeVineBase;
import growthcraft.grapes.common.utils.GrapeBlockCheck;
import growthcraft.grapes.common.utils.GrapeTypeUtils;
import growthcraft.grapes.shared.config.GrowthcraftGrapesConfig;
import growthcraft.grapes.shared.definition.IGrapeType;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrapeLeaves
extends BlockBush
implements IGrowable,
IBlockRope {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final int grapeLeavesGrowthRate = GrowthcraftGrapesConfig.grapeLeavesGrowthRate;
    private final int grapeSpawnRate = GrowthcraftGrapesConfig.grapeSpawnRate;
    private final int grapeVineSupportedLength = GrowthcraftGrapesConfig.grapeVineSupportedLength;
    public static final PropertyInteger SUBTYPE = BlockGrapeVineBase.SUBTYPE;
    public static final PropertyBool OPAQUEBELOW = PropertyBool.func_177716_a((String)"opaquebelow");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private final BlockGrapeFruit blockFruit;
    private final IGrapeType[] grapeTypes;

    public BlockGrapeLeaves(IGrapeType[] grapeTypes, BlockGrapeFruit blockFruit) {
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)OPAQUEBELOW, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
        this.blockFruit = blockFruit;
        this.grapeTypes = grapeTypes;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockGrapeLeaves.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
    }

    public boolean canGrowOutwardsOnRope(World world, BlockPos pos) {
        if (BlockCheck.isRope(world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c())) {
            return true;
        }
        if (BlockCheck.isRope(world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c())) {
            return true;
        }
        if (BlockCheck.isRope(world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c())) {
            return true;
        }
        return BlockCheck.isRope(world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c());
    }

    public boolean canGrowOutwards(World world, BlockPos pos) {
        boolean leavesToTheWest;
        boolean leavesToTheSouth = world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c() == this;
        boolean leavesToTheNorth = world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c() == this;
        boolean leavesToTheEast = world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c() == this;
        boolean bl = leavesToTheWest = world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c() == this;
        if (!(leavesToTheSouth || leavesToTheNorth || leavesToTheEast || leavesToTheWest)) {
            return false;
        }
        return this.isSupported(world, pos);
    }

    public boolean canGrowHere(World world, BlockPos pos) {
        if (BlockCheck.isRope(world.func_180495_p(pos).func_177230_c())) {
            return this.canGrowOutwards(world, pos);
        }
        return false;
    }

    private void setGrapeBlock(World world, BlockPos pos, IBlockState state) {
        int type = (Integer)state.func_177229_b((IProperty)SUBTYPE);
        world.func_180501_a(pos, this.blockFruit.func_176223_P().func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(type)), 3);
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        EnumFacing dir;
        BlockPos posDir;
        BlockPos posDown = pos.func_177977_b();
        if (worldIn.func_175623_d(posDown) && rand.nextInt(this.grapeSpawnRate) == 0) {
            this.setGrapeBlock(worldIn, posDown, state);
        }
        if (worldIn.field_73012_v.nextInt(this.grapeLeavesGrowthRate) == 0 && this.canGrowOutwardsOnRope(worldIn, pos) && this.canGrowHere(worldIn, posDir = pos.func_177982_a((dir = BlockCheck.DIR4[rand.nextInt(4)]).func_82601_c(), 0, dir.func_82599_e()))) {
            int type = (Integer)state.func_177229_b((IProperty)SUBTYPE);
            worldIn.func_180501_a(posDir, this.func_176223_P().func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(type)), 3);
            BlockPos below = posDir.func_177977_b();
            IBlockState stateBelow = worldIn.func_180495_p(below);
            if (stateBelow.func_177230_c() instanceof BlockGrapeVine1) {
                BlockGrapeVine1 blockBelow = (BlockGrapeVine1)stateBelow.func_177230_c();
                if ((Integer)stateBelow.func_177229_b((IProperty)BlockGrapeVineBase.AGE) < blockBelow.getMaxAge()) {
                    worldIn.func_180501_a(below, stateBelow.func_177226_a((IProperty)BlockGrapeVineBase.AGE, (Comparable)Integer.valueOf(blockBelow.getMaxAge())), 3);
                }
            }
        }
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        BlockPos posDown = pos.func_177977_b();
        if (worldIn.func_175623_d(posDown)) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            EnumFacing dir = BlockCheck.DIR4[i];
            BlockPos posDir = pos.func_177982_a(dir.func_82601_c(), 0, dir.func_82599_e());
            if (!this.canGrowHere(worldIn, posDir)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState other = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = other.func_177230_c();
        return block != this || blockState.func_177229_b((IProperty)SUBTYPE) != other.func_177229_b((IProperty)SUBTYPE);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!this.isSupported(worldIn, pos, state)) {
            worldIn.func_175656_a(pos, GrowthcraftCoreBlocks.rope_fence.getDefaultState());
            List drops = super.getDrops((IBlockAccess)worldIn, pos, state, 0);
            for (ItemStack drop : drops) {
                BlockGrapeLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        } else if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
            this.func_176474_b(worldIn, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    protected boolean func_185514_i(IBlockState state) {
        return true;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean isSupported(World world, BlockPos pos) {
        if (this.isSupportedByTrunk(world, pos)) {
            return true;
        }
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-this.grapeVineSupportedLength, 0, -this.grapeVineSupportedLength), (BlockPos)pos.func_177982_a(this.grapeVineSupportedLength, 0, this.grapeVineSupportedLength))) {
            if (!this.isSupportedByTrunk(world, (BlockPos)blockpos$mutableblockpos)) continue;
            return true;
        }
        return false;
    }

    public boolean isSupported(World world, BlockPos pos, IBlockState state) {
        return this.isSupported(world, pos);
    }

    public boolean isSupportedByTrunk(World world, BlockPos pos) {
        return this.isTrunk(world, pos.func_177977_b());
    }

    private boolean isTrunk(World world, BlockPos pos) {
        return GrapeBlockCheck.isGrapeVineTrunk(world.func_180495_p(pos).func_177230_c());
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canConnectRopeTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block instanceof IBlockRope;
    }

    @Override
    public boolean canRopeBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block == GrowthcraftCoreBlocks.rope_fence.getBlock() || block == GrowthcraftCoreBlocks.rope_knot.getBlock();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        drops.add(GrowthcraftCoreItems.rope.asStack(1));
        return drops;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int typeID = (Integer)state.func_177229_b((IProperty)SUBTYPE);
        IGrapeType type = GrapeTypeUtils.getTypeBySubID(this.grapeTypes, typeID);
        return type.asSeedsStack().func_77973_b();
    }

    public int func_180651_a(IBlockState state) {
        int typeID = (Integer)state.func_177229_b((IProperty)SUBTYPE);
        IGrapeType type = GrapeTypeUtils.getTypeBySubID(this.grapeTypes, typeID);
        return type.asSeedsStack().func_77952_i();
    }

    public int func_149745_a(Random random) {
        return random.nextInt(3) == 0 ? 1 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SUBTYPE, NORTH, EAST, SOUTH, WEST, UP, DOWN, OPAQUEBELOW});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= (Integer)state.func_177229_b((IProperty)SUBTYPE) & 7;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState stateBelow = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177226_a((IProperty)OPAQUEBELOW, (Comparable)Boolean.valueOf(stateBelow.func_185914_p())).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.WEST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.DOWN)));
    }
}

