/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.grapes.common.blocks;

import growthcraft.cellar.shared.init.GrowthcraftCellarItems;
import growthcraft.core.shared.block.GrowthcraftBlockBase;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.grapes.common.blocks.BlockGrapeLeaves;
import growthcraft.grapes.common.blocks.BlockGrapeVineBase;
import growthcraft.grapes.common.utils.GrapeTypeUtils;
import growthcraft.grapes.shared.config.GrowthcraftGrapesConfig;
import growthcraft.grapes.shared.definition.IGrapeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrapeFruit
extends GrowthcraftBlockBase {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.1875, 0.5, 0.1875, 0.8125, 1.0, 0.8125);
    private static final PropertyInteger SUBTYPE = BlockGrapeVineBase.SUBTYPE;
    private Random rand = new Random();
    protected int bayanusDropRarity = GrowthcraftGrapesConfig.bayanusDropRarity;
    protected int grapesDropMin = GrowthcraftGrapesConfig.grapesDropMin;
    protected int grapesDropMax = GrowthcraftGrapesConfig.grapesDropMax;
    private final IGrapeType[] grapeTypes;

    public BlockGrapeFruit(IGrapeType[] grapeTypes) {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(0)));
        this.grapeTypes = grapeTypes;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.fellBlockAsItem(worldIn, pos);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            this.fellBlockAsItem(worldIn, pos);
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.fellBlockAsItem(worldIn, pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockGrapeLeaves;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.getFruitItemStackForBlock(state);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public ItemStack getFruitItemStackForBlock(IBlockState state) {
        int typeID = (Integer)state.func_177229_b((IProperty)SUBTYPE);
        IGrapeType type = GrapeTypeUtils.getTypeBySubID(this.grapeTypes, typeID);
        if (type != null) {
            return type.asStack();
        }
        return ItemStack.field_190927_a;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        ItemStack stack = this.getFruitItemStackForBlock(state);
        return !ItemUtils.isEmpty(stack) ? stack.func_77973_b() : null;
    }

    public int func_149745_a(Random random) {
        return this.grapesDropMin + random.nextInt(this.grapesDropMax - this.grapesDropMin);
    }

    public int func_180651_a(IBlockState state) {
        ItemStack stack = this.getFruitItemStackForBlock(state);
        return !ItemUtils.isEmpty(stack) ? stack.func_77960_j() : 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.func_149745_a(this.rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, this.rand, fortune);
            if (item != null) {
                ret.add(new ItemStack(item, 1, this.func_180651_a(state)));
            }
            if (this.rand.nextInt(this.bayanusDropRarity) != 0) continue;
            ret.add(GrowthcraftCellarItems.EnumYeast.BAYANUS.asStack(1));
        }
        return ret;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SUBTYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= (Integer)state.func_177229_b((IProperty)SUBTYPE) & 7;
    }
}

