/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.utils;

public class Rectangle {
    public int x;
    public int y;
    public int w;
    public int h;

    public Rectangle(int ix, int iy, int iw, int ih) {
        this.x = ix;
        this.y = iy;
        this.w = iw;
        this.h = ih;
    }

    public Rectangle(Rectangle rect) {
        this(rect.x, rect.y, rect.w, rect.h);
    }

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle copy() {
        return new Rectangle(this);
    }

    public Rectangle translate(int tx, int ty) {
        this.x += tx;
        this.y += ty;
        return this;
    }

    public Rectangle scale(float tx, float ty) {
        this.w = (int)((float)this.w * tx);
        this.h = (int)((float)this.h * ty);
        return this;
    }

    public Rectangle moveto(int tx, int ty) {
        this.x = tx;
        this.y = ty;
        return this;
    }

    public Rectangle resize(int tw, int th) {
        this.w = tw;
        this.h = th;
        return this;
    }

    public Rectangle set(int px, int py, int pw, int ph) {
        return this.moveto(px, py).resize(pw, ph);
    }

    public Rectangle set(Rectangle rect) {
        return this.set(rect.x, rect.y, rect.w, rect.h);
    }

    public boolean contains(int ix, int iy) {
        return ix >= this.x && iy >= this.y && ix < this.x + this.w && iy < this.y + this.h;
    }

    public int x1() {
        return this.x;
    }

    public int x2() {
        return this.x + this.w;
    }

    public int y1() {
        return this.y;
    }

    public int y2() {
        return this.y + this.h;
    }

    public boolean isEmpty() {
        return this.w == 0 || this.h == 0;
    }
}

