/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.tileentity.feature;

import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public interface IFluidTankOperable {
    default public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return GrowthcraftFluidUtils.convertTankPropsToInfo(this.getTankProperties(from));
    }

    public IFluidTankProperties[] getTankProperties(EnumFacing var1);

    default public boolean canFill(EnumFacing from, Fluid fluid) {
        for (IFluidTankProperties props : this.getTankProperties(from)) {
            if (!props.canFill() || !props.canFillFluidType(new FluidStack(fluid, 1))) continue;
            return true;
        }
        return false;
    }

    default public boolean canDrain(EnumFacing from, Fluid fluid) {
        for (IFluidTankProperties props : this.getTankProperties(from)) {
            if (!props.canDrain() || !props.canDrainFluidType(new FluidStack(fluid, 1))) continue;
            return true;
        }
        return false;
    }

    public int fill(EnumFacing var1, FluidStack var2, boolean var3);

    public FluidStack drain(EnumFacing var1, int var2, boolean var3);

    public FluidStack drain(EnumFacing var1, FluidStack var2, boolean var3);
}

