/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.tileentity.device;

import growthcraft.cellar.shared.processing.common.IProcessingRecipeBase;
import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class DeviceProgressive<T extends IProcessingRecipeBase>
extends DeviceBase {
    protected double time;
    protected int timeMax;
    protected boolean recheckRecipe = true;
    private T activeRecipe;

    public DeviceProgressive(GrowthcraftTileDeviceBase te) {
        super(te);
    }

    protected T loadRecipe() {
        return null;
    }

    public void markForRecipeRecheck() {
        this.recheckRecipe = true;
    }

    public T refreshRecipe() {
        T recipe = this.loadRecipe();
        if (recipe != null && recipe != this.activeRecipe) {
            if (this.activeRecipe != null) {
                this.resetTime();
            }
            this.activeRecipe = recipe;
            this.markDirty();
        } else if (recipe == null && this.activeRecipe != null) {
            this.activeRecipe = null;
            this.resetTime();
            this.markDirty();
        }
        this.recheckRecipe = false;
        return this.activeRecipe;
    }

    protected boolean canProcess() {
        return this.activeRecipe != null;
    }

    protected void process(T recipe) {
        if (!this.canProcess()) {
            return;
        }
    }

    public T getWorkingRecipe() {
        if (this.recheckRecipe) {
            this.refreshRecipe();
        }
        return this.activeRecipe;
    }

    protected float getSpeedMultiplier() {
        return 1.0f;
    }

    public float getProgress() {
        int tmx = this.getTimeMax();
        if (tmx > 0) {
            return (float)this.time / (float)tmx;
        }
        return 0.0f;
    }

    public int getProgressScaled(int scale) {
        int tmx = this.getTimeMax();
        if (tmx > 0) {
            return (int)this.time * scale / tmx;
        }
        return 0;
    }

    public double getTime() {
        return this.time;
    }

    public int getTimeMax() {
        return this.timeMax;
    }

    public void setTime(int t) {
        this.time = t;
    }

    public void setTimeMax(int t) {
        this.timeMax = t;
    }

    public boolean resetTime() {
        if (this.time != 0.0) {
            this.setTime(0);
            return true;
        }
        return false;
    }

    public void increaseTime() {
        this.time += (double)this.getSpeedMultiplier();
    }

    public void update() {
        try {
            T recipe = this.getWorkingRecipe();
            if (this.canProcess()) {
                this.setTimeMax(recipe.getTime());
                if (this.time >= (double)this.timeMax) {
                    this.process(recipe);
                    this.resetTime();
                } else {
                    this.increaseTime();
                }
            } else if (this.resetTime()) {
                this.markForUpdate(true);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.time = data.func_74769_h("time");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74780_a("time", this.time);
    }

    @Override
    public boolean readFromStream(ByteBuf buf) {
        super.readFromStream(buf);
        this.time = buf.readDouble();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf buf) {
        super.writeToStream(buf);
        buf.writeDouble(this.time);
        return false;
    }
}

