/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.tileentity.component;

import growthcraft.core.shared.io.nbt.INBTSerializableContext;
import growthcraft.core.shared.io.stream.IStreamable;
import growthcraft.core.shared.tileentity.component.HeatBlockComponent;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileHeatingComponent
implements INBTSerializableContext,
IStreamable {
    private TileEntity tileEntity;
    private HeatBlockComponent heatBlockComponent;
    private float heat;
    private float heatLoss = 0.01f;
    private float heatGain = 0.01f;

    public TileHeatingComponent(@Nonnull TileEntity te, float adjacentHeating) {
        this.tileEntity = te;
        this.heatBlockComponent = new HeatBlockComponent(this.tileEntity, adjacentHeating);
    }

    public void update() {
        float heatMul = this.heatBlockComponent.getHeatMultiplier();
        if (heatMul > 0.0f) {
            this.heat = this.heat < heatMul ? (this.heat += this.heatGain * heatMul) : (this.heat -= this.heatGain * heatMul);
        } else if (this.heat > 0.0f) {
            this.heat -= this.heatLoss;
        }
    }

    public TileHeatingComponent setHeatMultiplier(float h) {
        this.heat = h;
        return this;
    }

    public float getHeatMultiplier() {
        return this.heat;
    }

    public boolean isHeated() {
        return this.heat > 0.0f;
    }

    private void readFromNBT(@Nonnull NBTTagCompound tag) {
        this.heat = tag.func_74760_g("heat");
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag, @Nonnull String name) {
        if (tag.func_74764_b(name)) {
            this.readFromNBT(tag.func_74775_l(name));
        }
    }

    private void writeToNBT(@Nonnull NBTTagCompound tag) {
        tag.func_74776_a("heat", this.heat);
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound tag, @Nonnull String name) {
        NBTTagCompound target = new NBTTagCompound();
        this.writeToNBT(target);
        tag.func_74782_a(name, (NBTBase)target);
    }

    @Override
    public boolean readFromStream(ByteBuf stream) {
        this.heat = stream.readFloat();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf stream) {
        stream.writeFloat(this.heat);
        return false;
    }
}

