/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.handlers;

import growthcraft.core.shared.utils.ColorUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;

public class BlockColorHandler {
    private BlockColorHandler() {
    }

    public static void registerBlockColorHandler(Block block, int hexColor) {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            float[] color = ColorUtils.getFloat4ARGB(hexColor);
            if (worldIn != null && pos != null) {
                int i;
                float[] baseColor = ColorUtils.getFloat4ARGB(ColorizerFoliage.func_77468_c());
                float[] curColor = ColorUtils.getFloat4ARGB(BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos));
                float[] colorRatio = new float[3];
                for (i = 1; i < 3; ++i) {
                    colorRatio[i - 1] = curColor[i] / baseColor[i];
                }
                for (i = 1; i < 3; ++i) {
                    int n = i;
                    color[n] = color[n] * colorRatio[i - 1];
                }
            }
            return ColorUtils.getIntARGB(color);
        }, new Block[]{block});
    }
}

