/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.fluids;

import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.definition.IMultiFluidStacks;
import growthcraft.core.shared.fluids.FluidTag;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidTest {
    private FluidTest() {
    }

    public static boolean isValid(@Nullable Fluid fluid) {
        return fluid != null;
    }

    public static boolean isValid(@Nullable FluidStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.getFluid() == null) {
            return false;
        }
        return stack.amount > 0;
    }

    public static boolean hasTags(@Nullable Fluid fluid, FluidTag ... tags) {
        if (FluidTest.isValid(fluid)) {
            return CoreRegistry.instance().fluidDictionary().hasFluidTags(fluid, tags);
        }
        return false;
    }

    public static boolean hasTags(@Nullable FluidStack stack, FluidTag ... tags) {
        if (FluidTest.isValid(stack)) {
            return CoreRegistry.instance().fluidDictionary().hasFluidTags(stack.getFluid(), tags);
        }
        return false;
    }

    public static boolean areFluidsEqual(@Nullable FluidStack expected, @Nullable FluidStack other) {
        if (expected == null) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        return expected.isFluidEqual(other);
    }

    public static boolean areStacksIdentical(@Nullable FluidStack expected, @Nullable FluidStack other) {
        if (expected == null) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        return expected.isFluidStackIdentical(other);
    }

    public static boolean fluidMatches(@Nullable FluidStack expected, @Nullable Fluid other) {
        if (expected == null) {
            return other == null;
        }
        return expected.getFluid() == other;
    }

    public static boolean fluidMatches(@Nullable FluidStack expected, @Nullable FluidStack other) {
        return FluidTest.areFluidsEqual(expected, other);
    }

    public static boolean fluidMatches(@Nullable IMultiFluidStacks expected, @Nullable FluidStack other) {
        if (expected == null) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        return expected.containsFluidStack(other);
    }

    public static boolean hasEnough(@Nullable FluidStack expected, @Nullable FluidStack actual) {
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return false;
        }
        if (!expected.isFluidEqual(actual)) {
            return false;
        }
        return actual.amount >= expected.amount;
    }

    public static boolean hasEnough(@Nullable IMultiFluidStacks expected, @Nullable FluidStack actual) {
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return false;
        }
        if (!expected.containsFluidStack(actual)) {
            return false;
        }
        return actual.amount >= expected.getAmount();
    }

    public static boolean isValidAndExpected(@Nonnull FluidStack expected, @Nullable FluidStack stack) {
        return FluidTest.isValid(stack) && expected.isFluidEqual(stack);
    }

    public static boolean isValidAndExpected(@Nonnull Fluid expected, @Nullable FluidStack stack) {
        return FluidTest.isValid(stack) && stack.getFluid() == expected;
    }

    public static boolean isValidAndExpected(@Nonnull List expectedFluids, @Nonnull List<FluidStack> givenFluids) {
        if (expectedFluids.size() != givenFluids.size()) {
            return false;
        }
        for (int i = 0; i < expectedFluids.size(); ++i) {
            Object expected = expectedFluids.get(i);
            FluidStack actual = givenFluids.get(i);
            if (expected != null) {
                if (!FluidTest.isValid(actual)) {
                    return false;
                }
                if (expected instanceof IMultiFluidStacks) {
                    if (((IMultiFluidStacks)expected).containsFluidStack(actual)) continue;
                    return false;
                }
                if (expected instanceof FluidStack) {
                    if (((FluidStack)expected).isFluidEqual(actual)) continue;
                    return false;
                }
                return false;
            }
            if (actual == null) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEnoughAndExpected(@Nonnull List expectedFluids, @Nonnull List<FluidStack> givenFluids) {
        if (expectedFluids.size() != givenFluids.size()) {
            return false;
        }
        for (int i = 0; i < expectedFluids.size(); ++i) {
            Object expected = expectedFluids.get(i);
            FluidStack actual = givenFluids.get(i);
            if (expected != null) {
                if (!FluidTest.isValid(actual)) {
                    return false;
                }
                if (expected instanceof IMultiFluidStacks) {
                    if (FluidTest.hasEnough((IMultiFluidStacks)expected, actual)) continue;
                    return false;
                }
                if (expected instanceof FluidStack) {
                    if (FluidTest.hasEnough((FluidStack)expected, actual)) continue;
                    return false;
                }
                return false;
            }
            if (actual == null) continue;
            return false;
        }
        return true;
    }
}

