/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.fluids;

import growthcraft.core.shared.definition.DuplicateRegistrationException;
import growthcraft.core.shared.fluids.FluidTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class FluidTagsRegistry {
    private Map<String, FluidTag> nameToTag = new HashMap<String, FluidTag>();

    public void registerTag(@Nonnull FluidTag tag) {
        if (this.nameToTag.containsKey(tag.getName())) {
            throw DuplicateRegistrationException.newFor(tag);
        }
        this.nameToTag.put(tag.getName(), tag);
    }

    public FluidTag createTag(@Nonnull String name) {
        FluidTag tag = new FluidTag(name);
        this.registerTag(tag);
        return tag;
    }

    public Collection<String> getNames() {
        return this.nameToTag.keySet();
    }

    public Collection<FluidTag> getTags() {
        return this.nameToTag.values();
    }

    public FluidTag findTag(@Nonnull String name) {
        return this.nameToTag.get(name);
    }

    public List<FluidTag> expandTagNames(@Nonnull List<String> tagNames) {
        ArrayList<FluidTag> tags = new ArrayList<FluidTag>();
        for (String name : tagNames) {
            tags.add(this.findTag(name));
        }
        return tags;
    }
}

