/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.fluids;

import growthcraft.core.shared.definition.IFluidStackFactory;
import growthcraft.core.shared.io.nbt.NBTHelper;
import growthcraft.core.shared.utils.HashKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidKey
extends HashKey
implements IFluidStackFactory {
    public final Fluid fluid;
    public final NBTTagCompound compoundTag;

    public FluidKey(@Nonnull Fluid pfluid, @Nullable NBTTagCompound tag) {
        this.fluid = pfluid;
        this.compoundTag = NBTHelper.compoundTagPresence(tag);
        this.generateHashCode();
    }

    public FluidKey(@Nonnull Fluid pfluid) {
        this(pfluid, null);
    }

    public FluidKey(@Nonnull FluidStack pfluidStack) {
        this(pfluidStack.getFluid(), pfluidStack.tag);
    }

    private void generateHashCode() {
        this.hash = this.fluid.hashCode();
        this.hash = 31 * this.hash + (this.compoundTag != null ? this.compoundTag.hashCode() : 0);
    }

    @Override
    public FluidStack asFluidStack(int size) {
        return new FluidStack(this.fluid, size, NBTHelper.copyCompoundTag(this.compoundTag));
    }

    @Override
    public FluidStack asFluidStack() {
        return this.asFluidStack(1);
    }
}

