/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.definition;

import growthcraft.core.shared.definition.ISubItemStackFactory;
import growthcraft.core.shared.definition.ObjectDefinition;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockTypeDefinition<T extends Block>
extends ObjectDefinition<T>
implements ISubItemStackFactory {
    public BlockTypeDefinition(@Nonnull T block) {
        super(block);
    }

    @Nonnull
    public final T getBlock() {
        return (T)((Block)this.getObject());
    }

    public final Item getItem() {
        return Item.func_150898_a(this.getBlock());
    }

    @Nonnull
    public final IBlockState getDefaultState() {
        return this.getBlock().func_176223_P();
    }

    @Override
    @Nonnull
    public ItemStack asStack(int size, int damage) {
        return new ItemStack(this.getBlock(), size, damage);
    }

    @Nonnull
    public ItemStack getItemAsStack(int size) {
        return new ItemStack(this.getItem(), size);
    }

    @Nonnull
    public ItemStack getItemAsStack(int size, int damage) {
        return new ItemStack(this.getItem(), size, damage);
    }

    public boolean equals(Block other) {
        return Block.func_149680_a(this.getBlock(), (Block)other);
    }

    public boolean equals(Item other) {
        return other == this.getItem();
    }

    public boolean isSameAs(Block other) {
        return this.getBlock() == other;
    }

    public void registerBlock(IForgeRegistry<Block> registry) {
        registry.register(this.getBlock());
    }

    public void registerBlockItem(IForgeRegistry<Item> registry, ItemBlock itemBlock) {
        registry.register(itemBlock.setRegistryName(this.getBlock().getRegistryName()));
    }

    public void registerBlockItem(IForgeRegistry<Item> registry) {
        this.registerBlockItem(registry, new ItemBlock(this.getBlock()));
    }

    public void registerBlock(IForgeRegistry<Block> registry, ResourceLocation name) {
        this.getBlock().func_149663_c(name.func_110623_a());
        this.getBlock().setRegistryName(name);
        this.registerBlock(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemRender() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a(this.getBlock()), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getBlock().getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemRender(int meta, String fileName) {
        String modID = this.getBlock().getRegistryName().func_110624_b();
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a(this.getBlock()), (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(modID, fileName), "inventory"));
    }
}

