/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import growthcraft.core.shared.GrowthcraftLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.minecraftforge.common.config.Configuration;

public abstract class AbstractUserJSONConfig {
    public static final String DEFAULT_ENCODING = "UTF-8";
    protected final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private File targetConfigFile;
    private File targetDefaultConfigFile;

    protected abstract String getDefault();

    private void writeDefaultConfigTo(File file) {
        block16: {
            try {
                GrowthcraftLogger.getLogger("growthcraft").debug("Creating default json-config %s", (Object)file);
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() && !file.createNewFile()) {
                    GrowthcraftLogger.getLogger("growthcraft").error("Could not create default config %s", (Object)file);
                    return;
                }
                if (!file.canWrite()) break block16;
                try (FileWriter writer = new FileWriter(file);){
                    writer.write(this.getDefault());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract void loadFromBuffer(BufferedReader var1) throws IllegalStateException;

    public AbstractUserJSONConfig setConfigFile(File dir, String filename) {
        this.targetConfigFile = new File(dir, filename);
        this.targetDefaultConfigFile = new File(dir, filename + ".default");
        GrowthcraftLogger.getLogger("growthcraft").debug("Config file `%s` was set for `%s`", (Object)this.targetConfigFile, (Object)this);
        GrowthcraftLogger.getLogger("growthcraft").debug("DEFAULT Config file `%s` was set for `%s`", (Object)this.targetDefaultConfigFile, (Object)this);
        return this;
    }

    private void prepareUserConfig() throws IOException {
        if (!this.targetConfigFile.exists()) {
            if (this.targetConfigFile.getParentFile() != null) {
                this.targetConfigFile.getParentFile().mkdirs();
            }
            if (!this.targetConfigFile.createNewFile()) {
                GrowthcraftLogger.getLogger("growthcraft").error("Could not create config file `%s`", (Object)this.targetConfigFile);
                return;
            }
            if (this.targetDefaultConfigFile.exists()) {
                Files.copy((File)this.targetDefaultConfigFile, (File)this.targetConfigFile);
            } else {
                GrowthcraftLogger.getLogger("growthcraft").error("Could not copy default config file `%s` to `%s`", (Object)this.targetDefaultConfigFile, (Object)this.targetConfigFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUserConfigFile(File file) {
        BufferedReader buffer = null;
        Configuration.UnicodeInputStreamReader input = null;
        try {
            GrowthcraftLogger.getLogger("growthcraft").debug("Loading json-config %s", (Object)file);
            this.prepareUserConfig();
            if (file.canRead()) {
                input = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(file), DEFAULT_ENCODING);
                buffer = new BufferedReader((Reader)input);
                this.loadFromBuffer(buffer);
            } else {
                GrowthcraftLogger.getLogger("growthcraft").error("Could not read config file %s", (Object)file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException iOException) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadUserConfig() {
        this.writeDefaultConfigTo(this.targetDefaultConfigFile);
        try {
            this.readUserConfigFile(this.targetConfigFile);
            return;
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft").error("JSON Config '%s' contains errors", (Object)this.targetConfigFile);
            e.printStackTrace();
            GrowthcraftLogger.getLogger("growthcraft").warn("Falling back to default config file");
            this.readUserConfigFile(this.targetDefaultConfigFile);
            return;
        }
    }

    public void preInit() {
    }

    public void register() {
    }

    public void init() {
    }

    public void postInit() {
    }
}

