/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.handlers;

import growthcraft.core.shared.GrowthcraftLogger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerBucketFill {
    private static EventHandlerBucketFill INSTANCE = new EventHandlerBucketFill();
    private List<IBucketEntry> buckets = new ArrayList<IBucketEntry>();

    public static EventHandlerBucketFill instance() {
        return INSTANCE;
    }

    public void addEntry(@Nonnull IBucketEntry entry) {
        this.buckets.add(entry);
        GrowthcraftLogger.getLogger("growthcraft").debug("Added new Bucket Entry {%s}", (Object)entry);
    }

    public EventHandlerBucketFill register(Block block, ItemStack stack) {
        this.addEntry(new GenericBucketEntry(block, stack));
        return this;
    }

    public EventHandlerBucketFill register(Block block, Item item) {
        return this.register(block, new ItemStack(item, 1));
    }

    private ItemStack fillCustomBucket(FillBucketEvent event) {
        for (IBucketEntry entry : this.buckets) {
            if (!entry.matches(event.getWorld(), event.getTarget())) continue;
            entry.commit(event.getEntityPlayer(), event.getWorld(), event.getTarget());
            return entry.getItemStack();
        }
        return null;
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        if (event.getWorld().field_72995_K || event.getResult() != null || event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack result = this.fillCustomBucket(event);
        if (result != null) {
            event.setFilledBucket(result.func_77946_l());
            event.setResult(Event.Result.ALLOW);
        }
    }

    public static class GenericBucketEntry
    implements IBucketEntry {
        private final Block block;
        private final ItemStack itemStack;

        public GenericBucketEntry(Block blk, ItemStack stack) {
            this.block = blk;
            this.itemStack = stack;
        }

        @Override
        public ItemStack getItemStack() {
            return this.itemStack;
        }

        @Override
        public boolean matches(@Nonnull World world, @Nonnull RayTraceResult res) {
            IBlockState srcBlockState = world.func_180495_p(res.func_178782_a());
            Block srcBlock = srcBlockState.func_177230_c();
            if (this.block.equals(srcBlock)) {
                return srcBlock.func_176201_c(srcBlockState) == 0;
            }
            return false;
        }

        @Override
        public void commit(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull RayTraceResult res) {
            world.func_175698_g(res.func_178782_a());
        }

        public String toString() {
            return String.format("GenericBucketEntry{ block: {%s}, item_stack: {%s} }", this.block, this.itemStack);
        }
    }

    public static interface IBucketEntry {
        public ItemStack getItemStack();

        public boolean matches(@Nonnull World var1, @Nonnull RayTraceResult var2);

        public void commit(@Nonnull EntityPlayer var1, @Nonnull World var2, @Nonnull RayTraceResult var3);
    }
}

