/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.yeast.user;

import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.processing.yeast.user.UserYeastEntries;
import growthcraft.cellar.shared.processing.yeast.user.UserYeastEntry;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.config.AbstractUserJSONConfig;
import growthcraft.core.shared.config.schema.ItemKeySchema;
import growthcraft.core.shared.utils.BiomeUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;

public class UserYeastEntriesConfig
extends AbstractUserJSONConfig {
    private final UserYeastEntries defaultEntries = new UserYeastEntries();
    private UserYeastEntries entries;

    @Override
    protected String getDefault() {
        ItemKeySchema brewersYeast = new ItemKeySchema("growthcraft_cellar", "yeast", 1, 0);
        brewersYeast.setComment("Brewers Yeast");
        ItemKeySchema lagerYeast = new ItemKeySchema("growthcraft_cellar", "yeast", 1, 1);
        lagerYeast.setComment("Lager Yeast");
        ItemKeySchema etherealYeast = new ItemKeySchema("growthcraft_cellar", "yeast", 1, 3);
        etherealYeast.setComment("Ethereal Yeast");
        ItemKeySchema originYeast = new ItemKeySchema("growthcraft_cellar", "yeast", 1, 4);
        etherealYeast.setComment("Origin Yeast");
        UserYeastEntry brewers = new UserYeastEntry(brewersYeast, 1, new ArrayList<String>());
        brewers.setComment("Brewers yeast is the default yeast, which appears in all other biomes that are filled by the Lager or Ethereal");
        UserYeastEntry lager = new UserYeastEntry(lagerYeast, 10, new ArrayList<String>());
        lager.setComment("Lager yeast is found in COLD biomes, think snow places!");
        UserYeastEntry ethereal = new UserYeastEntry(etherealYeast, 10, new ArrayList<String>());
        ethereal.setComment("Ethereal yeast is found in MAGICAL biomes, because its special");
        UserYeastEntry origin = new UserYeastEntry(originYeast, 10, new ArrayList<String>());
        origin.setComment("Origin yeast is found in MUSHROOM biomes.");
        for (BiomeDictionary.Type biomeType : BiomeUtils.types) {
            String biomeTypeName = biomeType.getName();
            if (biomeType.equals(BiomeDictionary.Type.COLD)) {
                lager.biome_types.add(biomeTypeName);
                continue;
            }
            if (biomeType.equals(BiomeDictionary.Type.MAGICAL)) {
                ethereal.biome_types.add(biomeTypeName);
                continue;
            }
            if (biomeType.equals(BiomeDictionary.Type.MUSHROOM)) {
                origin.biome_types.add(biomeTypeName);
                continue;
            }
            brewers.biome_types.add(biomeTypeName);
        }
        this.defaultEntries.data.add(brewers);
        this.defaultEntries.data.add(ethereal);
        this.defaultEntries.data.add(lager);
        this.defaultEntries.data.add(origin);
        this.defaultEntries.setComment("Default Yeast Config v1.1.0");
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.entries = (UserYeastEntries)this.gson.fromJson((Reader)reader, UserYeastEntries.class);
    }

    private void addYeastEntry(UserYeastEntry entry) {
        if (entry == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Yeast entry was invalid.");
            return;
        }
        if (entry.item == null || entry.item.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Yeast item was invalid {%s}", (Object)entry);
            return;
        }
        for (ItemStack itemstack : entry.item.getItemStacks()) {
            if (entry.biome_types != null) {
                for (String biome : entry.biome_types) {
                    try {
                        BiomeDictionary.Type biomeType = BiomeUtils.fetchBiomeType(biome);
                        CellarRegistry.instance().yeast().addYeastToBiomeType(itemstack, entry.weight, biomeType);
                        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Added user yeast {%s} to biome type '%s'", (Object)itemstack, (Object)biome);
                    }
                    catch (BiomeUtils.BiomeTypeNotFound ex) {
                        GrowthcraftLogger.getLogger("growthcraft_cellar").error("A biome type '%s' for entry {%s} could not be found.", (Object)biome, (Object)entry);
                    }
                }
            }
            if (entry.biome_names == null) continue;
            for (String biomeName : entry.biome_names) {
                CellarRegistry.instance().yeast().addYeastToBiomeByName(itemstack, entry.weight, biomeName);
                GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Added user yeast {%s} to biome '%s'", (Object)itemstack, (Object)biomeName);
            }
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding %d yeast entries.", (Object)this.entries.data.size());
                for (UserYeastEntry entry : this.entries.data) {
                    this.addYeastEntry(entry);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft_cellar").error("Invalid yeast entries data");
            }
        }
    }
}

