/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.config;

import growthcraft.core.shared.GrowthcraftLogger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GrowthcraftCellarConfig {
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_PRODUCTION = "production";
    private static final String CATEGORY_CORKTREE = "cork_tree";
    public static Configuration configuration;
    public static boolean enableDiscardButton;
    public static boolean boozeEffectsEnabled;
    public static boolean boozeIsWater;
    public static boolean setFireToFallenLivingEntities;
    public static boolean dropItemsInBrewKettle;
    public static int brewKettleRainFillPerUnit;
    public static boolean brewKettleFillsWithRain;
    public static int fermentBarrelMaxCap;
    public static int cultureJarTimeMax;
    public static int cultureJarConsumption;
    public static int cultureJarMaxCap;
    public static int fruitPressMaxCap;
    public static boolean fermentBarrelUseCachedRecipe;
    public static int fermentTime;
    public static int brewKettleMaxCap;
    public static boolean allowFallbackRecipes;
    public static int corkBarkGrowthChance;

    public static void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        configuration = new Configuration(new File(directory.getPath(), "growthcraft/growthcraft-cellar.cfg"));
        GrowthcraftCellarConfig.readConfig();
    }

    public static void readConfig() {
        try {
            configuration.load();
            GrowthcraftCellarConfig.initGeneralConfig();
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").log(Level.ERROR, "Unable to load configuration files for Growthcraft Cellar!", (Throwable)e);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void initGeneralConfig() {
        enableDiscardButton = configuration.getBoolean("enableDiscardButton", CATEGORY_GENERAL, enableDiscardButton, "Provides a button in the GUI to 'dump' the fluid contents in the FluidTank.");
        boozeEffectsEnabled = configuration.getBoolean("boozeEffectsEnabled", CATEGORY_GENERAL, boozeEffectsEnabled, "Toggle the availability of booze effects.");
        boozeIsWater = configuration.getBoolean("boozeIsWater", CATEGORY_GENERAL, boozeIsWater, "Treat booze as water.");
        dropItemsInBrewKettle = configuration.getBoolean("dropItemsInBrewKettle", CATEGORY_GENERAL, dropItemsInBrewKettle, "When a brew kettle is destroyed, should the contains be dumped into the world.");
        brewKettleRainFillPerUnit = configuration.getInt("brewKettleRainFillPerUnit", CATEGORY_GENERAL, brewKettleRainFillPerUnit, 10, 100, "How much mb per rain does the kettle fill with water.");
        brewKettleFillsWithRain = configuration.getBoolean("brewKettleFillsWithRain", CATEGORY_GENERAL, brewKettleFillsWithRain, "Allow the kettle to fill with water when exposed to rain.");
        allowFallbackRecipes = configuration.getBoolean("allowFallbackRecipes", CATEGORY_PRODUCTION, true, "If true then fallback recipes are activated. E.g. booze spoiling when using invalid ingredient.");
        fermentBarrelMaxCap = configuration.getInt("fermentBarrelMaxCap", CATEGORY_PRODUCTION, fermentBarrelMaxCap, 1000, 10000, "Set the maximum capacity of the fermentation barrel.");
        cultureJarTimeMax = configuration.getInt("cultureJarTimeMax", CATEGORY_PRODUCTION, cultureJarTimeMax, 100, 2400, "Maximum time it takes to process something in the culture jar.");
        cultureJarConsumption = configuration.getInt("cultureJarConsumption", CATEGORY_PRODUCTION, cultureJarConsumption, 100, 1000, "Set the consumption rate of fluids in the culture jar.");
        cultureJarMaxCap = configuration.getInt("cultureJarMaxCap", CATEGORY_PRODUCTION, cultureJarMaxCap, 250, 2000, "Maximum fluid capacity of the culture jar.");
        fruitPressMaxCap = configuration.getInt("fruitPressMaxCap", CATEGORY_PRODUCTION, fruitPressMaxCap, 250, 4000, "Maximum fluid capacity of the fruit press.");
        fermentTime = configuration.getInt("fermentTime", CATEGORY_PRODUCTION, fermentTime, 100, 48000, "How many ticks to ferment fluid in the fermentation barrel.");
        brewKettleMaxCap = configuration.getInt("brewKettleMaxCap", CATEGORY_PRODUCTION, brewKettleMaxCap, 250, 4000, "Maximum fluid capacity of the brew kettle.");
        corkBarkGrowthChance = configuration.getInt("corkBarkGrowthChance", CATEGORY_CORKTREE, corkBarkGrowthChance, 0, 100, "Chance per ticket that stripped cork log will regrow cork bark.");
    }

    static {
        enableDiscardButton = true;
        boozeEffectsEnabled = true;
        boozeIsWater = false;
        setFireToFallenLivingEntities = true;
        dropItemsInBrewKettle = true;
        brewKettleRainFillPerUnit = 10;
        brewKettleFillsWithRain = true;
        fermentBarrelMaxCap = 4000;
        cultureJarTimeMax = 1200;
        cultureJarConsumption = 250;
        cultureJarMaxCap = 1000;
        fruitPressMaxCap = 1000;
        fermentBarrelUseCachedRecipe = true;
        fermentTime = 24000;
        brewKettleMaxCap = 1000;
        allowFallbackRecipes = true;
        corkBarkGrowthChance = 50;
    }
}

