/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.booze;

import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.booze.modifier.IModifierFunction;
import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.config.description.Describer;
import growthcraft.core.shared.effect.IPotionEffectFactory;
import growthcraft.core.shared.fluids.FluidTag;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BoozePotionEffectFactory
implements IPotionEffectFactory {
    private Potion potion;
    private int time;
    private int level;
    private Fluid booze;

    public BoozePotionEffectFactory(@Nonnull Fluid b, Potion potion, int tm, int lvl) {
        this.booze = b;
        this.potion = potion;
        this.time = tm;
        this.level = lvl;
    }

    public Potion getPotion() {
        return this.potion;
    }

    public int getTime() {
        return this.time;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public PotionEffect createPotionEffect(World world, Entity entity, Random random, Object data) {
        Collection<FluidTag> tags = CoreRegistry.instance().fluidDictionary().getFluidTags(this.booze);
        if (tags != null) {
            int tm = this.getTime();
            int lv = this.getLevel();
            for (FluidTag tag : tags) {
                IModifierFunction func = CellarRegistry.instance().booze().getModifierFunction(tag);
                if (func == null) continue;
                tm = func.applyTime(tm);
                lv = func.applyLevel(lv);
            }
            return new PotionEffect(this.getPotion(), tm, lv);
        }
        return null;
    }

    @Override
    public void getDescription(List<String> list) {
        PotionEffect pe = this.createPotionEffect(null, null, null, null);
        Describer.getPotionEffectDescription(list, pe);
    }

    private void readFromNBT(NBTTagCompound data) {
        this.booze = null;
        this.potion = Potion.func_188412_a((int)data.func_74762_e("id"));
        this.time = data.func_74762_e("time");
        this.level = data.func_74762_e("level");
        if (data.func_74764_b("fluid.name")) {
            this.booze = FluidRegistry.getFluid((String)data.func_74779_i("fluid.name"));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data, String name) {
        if (data.func_74764_b(name)) {
            NBTTagCompound subData = data.func_74775_l(name);
            this.readFromNBT(subData);
        }
    }

    private void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("id", Potion.func_188409_a((Potion)this.getPotion()));
        data.func_74768_a("time", this.getTime());
        data.func_74768_a("level", this.getLevel());
        if (this.booze != null) {
            data.func_74778_a("fluid.name", this.booze.getName());
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound target = new NBTTagCompound();
        String factoryName = CoreRegistry.instance().getPotionEffectFactoryRegistry().getName(this.getClass());
        target.func_74778_a("__name__", factoryName);
        this.writeToNBT(target);
        data.func_74782_a(name, (NBTBase)target);
    }
}

