/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.booze.BoozeTag;
import growthcraft.cellar.shared.processing.common.IProcessingRecipeBase;
import growthcraft.cellar.shared.processing.yeast.YeastRegistry;
import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.item.WeightedItemStack;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class YeastGenerator
extends DeviceProgressive {
    protected int consumption = 75;
    protected DeviceFluidSlot fluidSlot;
    protected DeviceInventorySlot invSlot;
    protected List<WeightedItemStack> tempItemList = new ArrayList<WeightedItemStack>();

    public YeastGenerator(TileEntityCellarDevice te, int fluidSlotIndex, int invSlotIndex) {
        super(te);
        this.fluidSlot = new DeviceFluidSlot(te, fluidSlotIndex);
        this.invSlot = new DeviceInventorySlot((IInventory)te, invSlotIndex);
        this.setTimeMax(1200);
    }

    public YeastGenerator setConsumption(int c) {
        this.consumption = c;
        return this;
    }

    public Biome getCurrentBiome() {
        return this.getWorld().func_180494_b(this.parent.func_174877_v());
    }

    public boolean canReplicateYeast(ItemStack stack) {
        if (stack.func_190916_E() >= stack.func_77976_d()) {
            return false;
        }
        return CellarRegistry.instance().yeast().isYeast(stack);
    }

    @Override
    public boolean canProcess() {
        if (this.fluidSlot.getAmount() < this.consumption) {
            return false;
        }
        ItemStack yeastItem = this.invSlot.get();
        if (!ItemUtils.isEmpty(yeastItem) && !this.canReplicateYeast(yeastItem)) {
            return false;
        }
        return CoreRegistry.instance().fluidDictionary().hasFluidTags(this.fluidSlot.getFluid(), BoozeTag.YOUNG);
    }

    public void consumeFluid() {
        this.fluidSlot.consume(this.consumption, true);
        this.markDirty();
    }

    protected void initProduceYeast() {
        HashSet<WeightedItemStack> tempItemSet = new HashSet<WeightedItemStack>();
        this.tempItemList.clear();
        Biome biome = this.getCurrentBiome();
        if (biome != null) {
            YeastRegistry reg = CellarRegistry.instance().yeast();
            Set<WeightedItemStack> yl = reg.getYeastListForBiomeName(biome.field_76791_y);
            if (yl != null) {
                tempItemSet.addAll(yl);
            }
            for (BiomeDictionary.Type t : BiomeDictionary.getTypes((Biome)biome)) {
                Set<WeightedItemStack> yeastList = reg.getYeastListForBiomeType(t);
                if (yeastList == null) continue;
                tempItemSet.addAll(yeastList);
            }
            if (tempItemSet.size() > 0) {
                this.tempItemList.addAll(tempItemSet);
                WeightedItemStack weightedItemStack = (WeightedItemStack)WeightedRandom.func_76271_a((Random)this.getWorld().field_73012_v, this.tempItemList);
                if (weightedItemStack != null && weightedItemStack.itemStack != null) {
                    ItemStack result = weightedItemStack.itemStack.func_77946_l();
                    this.invSlot.set(result);
                    this.consumeFluid();
                }
            }
        }
    }

    public void process(@Nullable IProcessingRecipeBase recipe) {
        if (this.invSlot.isEmpty()) {
            this.initProduceYeast();
        } else {
            ItemStack contents = this.invSlot.get();
            if (this.canReplicateYeast(contents)) {
                this.invSlot.set(ItemUtils.increaseStack(contents));
                this.consumeFluid();
            }
        }
    }

    @Override
    public void update() {
        if (this.canProcess()) {
            this.increaseTime();
            if (this.time >= (double)this.timeMax) {
                this.resetTime();
                this.process(null);
                this.markDirty();
            }
        } else if (this.resetTime()) {
            this.markDirty();
        }
        super.update();
    }
}

