/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.processing.culturing.ICultureRecipe;
import growthcraft.core.shared.tileentity.component.TileHeatingComponent;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import net.minecraft.inventory.IInventory;

public class CultureGenerator
extends DeviceProgressive<ICultureRecipe> {
    protected DeviceFluidSlot fluidSlot;
    protected DeviceInventorySlot invSlot;
    protected TileHeatingComponent heatComponent;

    public CultureGenerator(TileEntityCellarDevice te, TileHeatingComponent heatComp, int fluidSlotIndex, int invSlotIndex) {
        super(te);
        this.heatComponent = heatComp;
        this.fluidSlot = new DeviceFluidSlot(te, fluidSlotIndex);
        this.invSlot = new DeviceInventorySlot((IInventory)te, invSlotIndex);
        this.setTimeMax(1200);
    }

    @Override
    protected ICultureRecipe loadRecipe() {
        return CellarRegistry.instance().culturing().findRecipe(this.fluidSlot.get(), this.heatComponent.getHeatMultiplier());
    }

    public float getHeatMultiplier() {
        return this.heatComponent.getHeatMultiplier();
    }

    public boolean isHeated() {
        return this.heatComponent.isHeated();
    }

    @Override
    protected boolean canProcess() {
        ICultureRecipe recipe = (ICultureRecipe)this.getWorkingRecipe();
        if (recipe == null) {
            return false;
        }
        if (!this.fluidSlot.hasEnough(recipe.getInputFluidStack())) {
            return false;
        }
        return this.invSlot.hasCapacityFor(recipe.getOutputItemStack());
    }

    @Override
    protected void process(ICultureRecipe recipe) {
        if (!this.canProcess()) {
            return;
        }
        this.fluidSlot.consume(recipe.getInputFluidStack(), true);
        this.invSlot.increaseStack(recipe.getOutputItemStack());
    }
}

