/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import growthcraft.core.shared.fluids.InternalFluidIDHandler;
import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.feature.IGuiNetworkSync;
import growthcraft.core.shared.tileentity.feature.IInteractionObject;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class TileEntityCellarDevice
extends GrowthcraftTileDeviceBase
implements IGuiNetworkSync,
IInteractionObject {
    InternalFluidIDHandler fluidIds = new InternalFluidIDHandler();

    @Override
    public void receiveGUINetworkData(int id, int v) {
        if (id >= 50) {
            int tankIndex = (id - 50) / 3;
            switch ((id - 50) % 3) {
                case 0: {
                    FluidStack result = GrowthcraftFluidUtils.replaceFluidStack(this.fluidIds.getFluidByInternalID(v), this.getFluidStack(tankIndex));
                    if (result == null) break;
                    this.getFluidTank(tankIndex).setFluid(result);
                    break;
                }
                case 1: {
                    int t = this.getFluidAmount(tankIndex);
                    this.setFluidStack(tankIndex, GrowthcraftFluidUtils.updateFluidStackAmount(this.getFluidStack(tankIndex), t & 0xFFFF0000 | v));
                    break;
                }
                case 2: {
                    int t = this.getFluidAmount(tankIndex);
                    this.getFluidTank(tankIndex).setFluid(GrowthcraftFluidUtils.updateFluidStackAmount(this.getFluidStack(tankIndex), t & 0xFFFF | v << 16));
                    break;
                }
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        int i = 0;
        for (FluidTank tank : this.getFluidTanks()) {
            int offset = 50 + i * 3;
            FluidStack fluid = this.getFluidStack(i);
            iCrafting.func_71112_a(container, offset, fluid != null ? this.fluidIds.getInternalIDByFluid(fluid.getFluid()) : 0);
            iCrafting.func_71112_a(container, offset + 1, fluid != null ? fluid.amount & 0xFFFF : 0);
            iCrafting.func_71112_a(container, offset + 2, fluid != null ? fluid.amount >> 16 & 0xFFFF : 0);
            ++i;
        }
    }
}

