/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.worldgen;

import growthcraft.bees.GrowthcraftBees;
import growthcraft.bees.shared.config.GrowthcraftBeesConfig;
import growthcraft.bees.shared.init.GrowthcraftBeesBlocks;
import java.util.Random;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.apache.logging.log4j.Level;

public class BeeHiveWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator iChunkGenerator, IChunkProvider iChunkProvider) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPos chunkCenterPos = new BlockPos(chunkX * 16 + 8, world.func_189649_b(chunkX * 16 + 8, chunkZ * 16 + 8), chunkZ * 16 + 8);
        BlockPos chunkNorthWest = new BlockPos(chunkX * 16 + 4, world.func_189649_b(chunkX * 16 + 2, chunkZ * 16 + 2), chunkZ * 16 + 4);
        BlockPos chunkSouthEast = new BlockPos(chunkX * 16 + 12, world.func_189649_b(chunkX * 16 + 8, chunkZ * 16 + 8), chunkZ * 16 + 12);
        if (!BeeHiveWorldGen.isValidBiome(world)) {
            return;
        }
        if (random.nextInt(100) <= GrowthcraftBeesConfig.worldgenBeeHiveRarity) {
            int spawnedBeeHive = 0;
            mutableBlockPos.func_181079_c(chunkCenterPos.func_177958_n(), chunkCenterPos.func_177956_o(), chunkCenterPos.func_177952_p());
            IBlockState state = world.func_180495_p(mutableBlockPos.func_177977_b());
            if (GrowthcraftBeesConfig.isDebug) {
                GrowthcraftBees.logger.log(Level.DEBUG, "[DEBUG] Checking blocks in chunk [ %d, %d ] for generating BeeHive at [x = %d, y = %d, z = %d] %s", (Object)chunkX, (Object)chunkZ, (Object)mutableBlockPos.func_177958_n(), (Object)mutableBlockPos.func_177956_o(), (Object)mutableBlockPos.func_177952_p(), (Object)state.func_177230_c().getRegistryName());
            }
            Iterable blocksInArea = BlockPos.func_177980_a((BlockPos)chunkNorthWest, (BlockPos)chunkSouthEast);
            for (BlockPos pos : blocksInArea) {
                IBlockState blockState = world.func_180495_p(pos);
                if (blockState.func_177230_c() instanceof BlockLeaves && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockAir) {
                    BeeHiveWorldGen.setBlockToBeeHive(world, pos.func_177977_b());
                    ++spawnedBeeHive;
                }
                if (spawnedBeeHive < GrowthcraftBeesConfig.maxBeeHivesPerChunk) continue;
                break;
            }
        }
    }

    private static void setBlockToBeeHive(World world, BlockPos blockPos) {
        if (GrowthcraftBeesConfig.isDebug) {
            GrowthcraftBees.logger.log(Level.DEBUG, "Generating beehive at %d %d %d ", (Object)blockPos.func_177958_n(), (Object)blockPos.func_177956_o(), (Object)blockPos.func_177952_p());
        }
        world.func_175656_a(blockPos, GrowthcraftBeesBlocks.beeHive.getDefaultState());
    }

    private static boolean isValidBiome(World world) {
        return world.field_73011_w.getDimension() == 0;
    }
}

