/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.lib.config.user;

import growthcraft.bees.common.lib.config.BeesRegistry;
import growthcraft.bees.common.lib.config.user.UserBeeEntry;
import growthcraft.bees.common.lib.config.user.UserBeesEntries;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.config.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class UserBeesConfig
extends AbstractUserJSONConfig {
    private final UserBeesEntries defaultEntries = new UserBeesEntries();
    private UserBeesEntries entries;

    public UserBeeEntry addDefault(ItemStack bee) {
        UserBeeEntry entry = new UserBeeEntry(bee);
        this.defaultEntries.data.add(entry);
        return entry;
    }

    public UserBeeEntry addDefault(Item bee) {
        return this.addDefault(new ItemStack(bee, Short.MAX_VALUE));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader buff) throws IllegalStateException {
        this.entries = (UserBeesEntries)this.gson.fromJson((Reader)buff, UserBeesEntries.class);
    }

    private void addBeeEntry(UserBeeEntry entry) {
        if (entry == null) {
            GrowthcraftLogger.getLogger("growthcraft_bees").error("Invalid Entry");
            return;
        }
        if (entry.item == null || entry.item.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_bees").error("Invalid item for entry {%s}", (Object)entry);
            return;
        }
        for (ItemStack stack : entry.item.getItemStacks()) {
            BeesRegistry.instance().addBee(stack);
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                GrowthcraftLogger.getLogger("growthcraft_bees").debug("Adding %d user bee entries.", (Object)this.entries.data.size());
                for (UserBeeEntry entry : this.entries.data) {
                    this.addBeeEntry(entry);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft_bees").error("Config contains invalid data.");
            }
        }
    }
}

