/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.block;

import growthcraft.bees.common.tileentity.TileEntityBeeBox;
import growthcraft.core.shared.block.BlockUtils;
import growthcraft.core.shared.block.GrowthcraftRotatableBlockContainer;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBeeBox
extends GrowthcraftRotatableBlockContainer {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private int flammability;
    private int fireSpreadSpeed;

    public BlockBeeBox(String unlocalizedName) {
        super(Material.field_151575_d);
        this.setTileEntityType(TileEntityBeeBox.class);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(true);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_bees", unlocalizedName));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockBeeBox.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean isRotatable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing facing = BlockUtils.getDefaultDirection(world, pos, state);
            world.func_180501_a(pos, state.func_177226_a((IProperty)TYPE_ROTATION, (Comparable)facing), 3);
        }
    }

    protected EnumFacing setOrientWhenPlacing(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer) {
        EnumFacing facing = EnumFacing.func_176733_a((double)placer.field_70177_z);
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)TYPE_ROTATION, (Comparable)facing), 3);
        return facing;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultDirection(worldIn, pos, state);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.setOrientWhenPlacing(worldIn, pos, state, placer);
    }

    public BlockBeeBox setFlammability(int flam) {
        this.flammability = flam;
        return this;
    }

    public BlockBeeBox setFireSpreadSpeed(int speed) {
        this.fireSpreadSpeed = speed;
        return this;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireSpreadSpeed;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        TileEntityBeeBox te = (TileEntityBeeBox)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te != null) {
            te.updateBlockTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random random) {
        TileEntityBeeBox te;
        if (random.nextInt(24) != 0 || (te = (TileEntityBeeBox)this.getTileEntity((IBlockAccess)world, pos)) == null || te.hasBees()) {
            // empty if block
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntityBeeBox te = (TileEntityBeeBox)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te != null) {
            playerIn.openGui((Object)"growthcraft_bees", 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return EnumFacing.UP == side;
    }

    @Override
    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityBeeBox();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityBeeBox te = (TileEntityBeeBox)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return te.countHoney() * 15 / te.getHoneyCombMax();
        }
        return 0;
    }
}

