/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo.shared.config;

import growthcraft.core.shared.GrowthcraftLogger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GrowthcraftBambooConfig {
    private static Configuration configuration;
    public static final String CATEGORY_GENERAL = "general";
    public static boolean isDebug;
    public static String logLevel;
    public static boolean enableGrowthcraftBamboo;

    private GrowthcraftBambooConfig() {
    }

    public static void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        configuration = new Configuration(new File(directory.getPath(), "growthcraft/growthcraft-bamboo.cfg"));
        GrowthcraftBambooConfig.readConfig();
    }

    public static void readConfig() {
        try {
            configuration.load();
            GrowthcraftBambooConfig.initGeneralConfig();
            GrowthcraftBambooConfig.initDebugConfig();
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft_bamboo").log(Level.ERROR, "Unable to load configuration files for Growthcraft Bamboo!", (Throwable)e);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void initGeneralConfig() {
        enableGrowthcraftBamboo = configuration.getBoolean("enableGrowthcraftBamboo", CATEGORY_GENERAL, enableGrowthcraftBamboo, "Enable the usage of Growthcraft Bamboo.");
    }

    private static void initDebugConfig() {
        if ((logLevel = configuration.getString("logLevel", CATEGORY_GENERAL, logLevel, "Set standard logging levels. (INFO, ERROR, DEBUG)")).equalsIgnoreCase("debug")) {
            isDebug = true;
        }
    }

    static {
        isDebug = false;
        logLevel = "info";
        enableGrowthcraftBamboo = true;
    }
}

