/*
 * Decompiled with CFR 0.152.
 */
package elucent.gravelores.world;

import elucent.gravelores.ConfigManager;
import elucent.gravelores.GravelOres;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenGravelOres
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Block b;
        if (ConfigManager.orePileChance > 0 && !GravelOres.spawns.isEmpty() && world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && random.nextInt(ConfigManager.orePileChance) == 0 && (b = (Block)GravelOres.spawns.get(random.nextInt(GravelOres.spawns.size()))) != null) {
            int zz;
            IBlockState ore = b.func_176223_P();
            int xx = chunkX * 16 + 8 + random.nextInt(16);
            BlockPos top = world.func_175672_r(new BlockPos(xx, 64, zz = chunkZ * 16 + 8 + random.nextInt(16)));
            if (WorldGenGravelOres.biomeBlacklisted(world, top)) {
                return;
            }
            IBlockState state = world.func_180495_p(top);
            IBlockState below = world.func_180495_p(top.func_177977_b());
            if (below.func_185914_p() && state.func_177230_c().func_176200_f((IBlockAccess)world, top)) {
                int i;
                int tries = ConfigManager.orePileMinSize + random.nextInt(ConfigManager.orePileMaxSize - ConfigManager.orePileMinSize);
                ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
                blocks.add(top);
                for (i = 0; i < tries; ++i) {
                    EnumFacing face;
                    BlockPos start = (BlockPos)blocks.get(random.nextInt(blocks.size()));
                    BlockPos pos = start.func_177972_a(face = EnumFacing.func_82600_a((int)random.nextInt(6)));
                    IBlockState current = world.func_180495_p(pos);
                    if (!current.func_177230_c().func_176200_f((IBlockAccess)world, start.func_177972_a(face))) continue;
                    blocks.add(pos);
                }
                for (i = 0; i < blocks.size(); ++i) {
                    world.func_175656_a((BlockPos)blocks.get(i), ore);
                }
            }
        }
    }

    private static boolean biomeBlacklisted(World world, BlockPos pos) {
        if (!ConfigManager.hasBiomeBlacklist && !ConfigManager.hasBiomeWhitelist) {
            return false;
        }
        return BiomeDictionary.getTypes((Biome)world.func_180494_b(pos)).stream().anyMatch(type -> ConfigManager.biomeBlacklist.contains(type.getName()) || ConfigManager.hasBiomeWhitelist && !ConfigManager.biomeWhitelist.contains(type.getName()));
    }
}

