/*
 * Decompiled with CFR 0.152.
 */
package elucent.gravelores;

import elucent.gravelores.ConfigManager;
import elucent.gravelores.block.BlockExtraGravelOre;
import elucent.gravelores.block.BlockGravelOre;
import elucent.gravelores.proxy.CommonProxy;
import elucent.gravelores.world.WorldGenGravelOres;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="gravelores", version="1.8", dependencies="after:*", acceptedMinecraftVersions="[1.12]")
public class GravelOres {
    public static final String MODID = "gravelores";
    public static final String VERSION = "1.8";
    public static final String DEPENDENCIES = "after:*";
    public static List<BlockGravelOre> blocks = new ArrayList<BlockGravelOre>();
    public static List<BlockGravelOre> extraBlocks = new ArrayList<BlockGravelOre>();
    public static List<Pair<BlockGravelOre, String>> extraBlocksInspirations = new ArrayList<Pair<BlockGravelOre, String>>();
    public static List<BlockGravelOre> spawns = new ArrayList<BlockGravelOre>();
    public static BlockGravelOre iron_gravel_ore;
    public static BlockGravelOre coal_gravel_ore;
    public static BlockGravelOre redstone_gravel_ore;
    public static BlockGravelOre gold_gravel_ore;
    public static BlockGravelOre emerald_gravel_ore;
    public static BlockGravelOre lapis_gravel_ore;
    public static BlockGravelOre diamond_gravel_ore;
    public static BlockGravelOre copper_gravel_ore;
    public static BlockGravelOre lead_gravel_ore;
    public static BlockGravelOre tin_gravel_ore;
    public static BlockGravelOre silver_gravel_ore;
    public static BlockGravelOre nickel_gravel_ore;
    public static BlockGravelOre aluminum_gravel_ore;
    public static Material GRAVEL_ORE;
    @SidedProxy(clientSide="elucent.gravelores.proxy.ClientProxy", serverSide="elucent.gravelores.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger log;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ConfigManager());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigManager.init(event.getSuggestedConfigurationFile());
        GravelOres.registerAll();
        proxy.preInit(event);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : blocks) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (BlockGravelOre b : blocks) {
            event.getRegistry().register((IForgeRegistryEntry)b.itemBlock);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GravelOres.addReferenceProperties();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GravelOres.integrateOres();
        proxy.postInit(event);
    }

    private static void registerAll() {
        GRAVEL_ORE = new Material(MapColor.field_151670_w){

            public boolean func_76229_l() {
                return false;
            }
        };
        coal_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "coal_gravel_ore", "oreCoal", true).setInspiration(Blocks.field_150365_q).setHarvestProperties("shovel", 0).setHardness(1.6f);
        blocks.add(coal_gravel_ore);
        iron_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "iron_gravel_ore", "oreIron", true).setHarvestProperties("shovel", 1).setHardness(2.2f);
        blocks.add(iron_gravel_ore);
        lapis_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "lapis_gravel_ore", "oreLapis", true).setInspiration(Blocks.field_150369_x).setHarvestProperties("shovel", 1).setHardness(2.0f);
        blocks.add(lapis_gravel_ore);
        gold_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "gold_gravel_ore", "oreGold", true).setHarvestProperties("shovel", 2).setHardness(2.4f);
        blocks.add(gold_gravel_ore);
        redstone_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "redstone_gravel_ore", "oreRedstone", true).setInspiration(Blocks.field_150450_ax).setHarvestProperties("shovel", 2).setHardness(2.8f);
        blocks.add(redstone_gravel_ore);
        diamond_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "diamond_gravel_ore", "oreDiamond", true).setInspiration(Blocks.field_150482_ag).setHarvestProperties("shovel", 2).setHardness(3.0f);
        blocks.add(diamond_gravel_ore);
        emerald_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "emerald_gravel_ore", "oreEmerald", true).setInspiration(Blocks.field_150412_bA).setHarvestProperties("shovel", 2).setHardness(2.8f);
        blocks.add(emerald_gravel_ore);
        tin_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "tin_gravel_ore", "oreTin", true).setHarvestProperties("shovel", 0).setHardness(1.9f);
        blocks.add(tin_gravel_ore);
        nickel_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "nickel_gravel_ore", "oreNickel", true).setHarvestProperties("shovel", 2).setHardness(2.5f);
        blocks.add(nickel_gravel_ore);
        silver_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "silver_gravel_ore", "oreSilver", true).setHarvestProperties("shovel", 2).setHardness(2.6f);
        blocks.add(silver_gravel_ore);
        lead_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "lead_gravel_ore", "oreLead", true).setHarvestProperties("shovel", 2).setHardness(2.6f);
        blocks.add(lead_gravel_ore);
        copper_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "copper_gravel_ore", "oreCopper", true).setHarvestProperties("shovel", 0).setHardness(1.9f);
        blocks.add(copper_gravel_ore);
        aluminum_gravel_ore = new BlockGravelOre(GRAVEL_ORE, "aluminum_gravel_ore", "oreAluminum", true).setHarvestProperties("shovel", 0).setHardness(1.9f);
        blocks.add(aluminum_gravel_ore);
        HashSet<String> seen = new HashSet<String>();
        for (String s : ConfigManager.extraBlocks) {
            String[] parts = s.split(":");
            if (parts.length != 4 && parts.length != 6 && parts.length != 7) {
                log.error("Invalid extra ore entry '{}': should be in the format 'name:color:harvestLevel:resistance' or 'name:color:harvestLevel:resistance:modid:baseore:meta'", (Object)s);
                continue;
            }
            if (!parts[0].matches("^[A-Za-z0-9]+$")) {
                log.error("Invalid extra ore entry '{}': name can only contain letters and numbers", (Object)s);
                continue;
            }
            if (seen.contains(parts[0].toLowerCase())) {
                log.error("Invalid extra ore entry '{}': duplicate name {}", (Object)s, (Object)parts[0]);
                continue;
            }
            String dropString = null;
            if (parts.length > 5) {
                dropString = parts[4] + ":" + parts[5];
                if (parts.length == 7) {
                    dropString = dropString + ":" + parts[6];
                }
            }
            try {
                int color = Integer.parseInt(parts[1], 16);
                int harvestLevel = Integer.parseInt(parts[2]);
                float hardness = Float.parseFloat(parts[3]);
                String name = parts[0].substring(0, 1).toUpperCase() + parts[0].substring(1);
                BlockGravelOre block = new BlockExtraGravelOre(GRAVEL_ORE, name, color).setHarvestProperties("shovel", harvestLevel).setHardness(hardness);
                blocks.add(block);
                extraBlocks.add(block);
                extraBlocksInspirations.add((Pair<BlockGravelOre, String>)Pair.of((Object)((Object)block), (Object)dropString));
                seen.add(name.toLowerCase());
            }
            catch (NumberFormatException e) {
                log.error("Invalid extra ore entry '{}': color must be a six digit hex, harvest level an integer, and hardness a float", (Object)s, (Object)parts[1]);
            }
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenGravelOres(), (int)88);
    }

    private static void addReferenceProperties() {
        for (Pair<BlockGravelOre, String> pair : extraBlocksInspirations) {
            if (pair.getRight() == null) continue;
            String[] parts = ((String)pair.getRight()).split(":");
            BlockGravelOre ore = (BlockGravelOre)((Object)pair.getLeft());
            Block block = (Block)GameRegistry.findRegistry(Block.class).getValue(new ResourceLocation(parts[0], parts[1]));
            if (block == null) {
                log.warn("Failed to add drops for {}: failed to find block '{}'", (Object)ore.getRegistryName(), pair.getRight());
                continue;
            }
            int meta = 0;
            if (parts.length > 2) {
                try {
                    meta = Integer.parseInt(parts[2]);
                }
                catch (NumberFormatException e) {
                    log.error("Failed to add drops for {}: invalid metadata {}", (Object)ore.getRegistryName(), (Object)parts[2]);
                    continue;
                }
            }
            ore.setInspiration(block.func_176203_a(meta));
        }
        extraBlocksInspirations = null;
    }

    private static void integrateOres() {
        log.info("Started populating oregen list");
        HashMap<Integer, BlockGravelOre> furnaceOres = new HashMap<Integer, BlockGravelOre>(blocks.size());
        for (BlockGravelOre block : blocks) {
            boolean hasOreDict;
            String oreKey = block.oreKey;
            boolean bl = hasOreDict = !OreDictionary.getOres((String)oreKey, (boolean)false).isEmpty();
            if (extraBlocks.contains((Object)block) || hasOreDict) {
                OreDictionary.registerOre((String)oreKey, (Block)block);
                if (!ConfigManager.blacklist.contains(oreKey)) {
                    Integer weight = ConfigManager.weights.get(oreKey);
                    if (weight == null) {
                        weight = 10;
                    }
                    GravelOres.addSpawn(block, weight);
                }
                if (!hasOreDict) continue;
                furnaceOres.put(OreDictionary.getOreID((String)oreKey), block);
                continue;
            }
            block.setHidden();
        }
        log.info("Started generating ore recipes...");
        long time = System.nanoTime();
        ArrayList<Pair> furnaceRecipes = new ArrayList<Pair>(blocks.size());
        block1: for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            int[] testOreIDs;
            ItemStack test = ((ItemStack)entry.getKey()).func_77946_l();
            if (test.func_190926_b()) continue;
            if (test.func_77952_i() == Short.MAX_VALUE) {
                test.func_77964_b(0);
            }
            for (int testOreID : testOreIDs = OreDictionary.getOreIDs((ItemStack)test)) {
                BlockGravelOre block = (BlockGravelOre)((Object)furnaceOres.get(testOreID));
                if (block != null) {
                    furnaceRecipes.add(Pair.of((Object)((Object)block), entry.getValue()));
                    furnaceOres.remove(testOreID);
                    continue block1;
                }
                if (furnaceOres.isEmpty()) continue block1;
            }
        }
        for (Pair recipe : furnaceRecipes) {
            GameRegistry.addSmelting((Block)((Block)recipe.getLeft()), (ItemStack)((ItemStack)recipe.getRight()), (float)FurnaceRecipes.func_77602_a().func_151398_b((ItemStack)recipe.getRight()));
        }
        log.info("Ore recipe generation completed in " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.");
    }

    private static void addSpawn(BlockGravelOre block, int weight) {
        for (int i = 0; i < weight; ++i) {
            spawns.add(block);
        }
    }

    static {
        log = LogManager.getLogger((String)MODID);
    }
}

