/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.witch;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.witch.Entity_SpecialWitch;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityUndeadWitch
extends Entity_SpecialWitch {
    private static final String TAG_SKELETONS = "SkeletonCount";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityUndeadWitch.GET_TEXTURE_PATH("undead"))};
    public static ResourceLocation LOOT_TABLE;
    private int skeletonCount;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(7969893);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityUndeadWitch.ADD_BASE_LOOT(loot);
        loot.addLootTable("common", "Zombie loot", LootTableList.field_186383_ah);
        ResourceLocation name = EntityList.func_191306_a(EntitySkeleton.class);
        ItemStack spawnEgg = new ItemStack(Items.field_151063_bx);
        ItemMonsterPlacer.func_185078_a((ItemStack)spawnEgg, (ResourceLocation)name);
        loot.addUncommonDrop("uncommon", "Spawn egg", spawnEgg);
    }

    public EntityUndeadWitch(World world) {
        super(world);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.skeletonCount = 3 + this.field_70146_Z.nextInt(4);
        this.field_70728_aV += 2;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    protected ItemStack pickThrownPotionByType(ItemStack potion, EntityLivingBase target, float distanceFactor, float distance) {
        if (this.skeletonCount > 0 && this.field_70146_Z.nextInt(4) == 0) {
            --this.skeletonCount;
            EntitySkeleton skeleton = new EntitySkeleton(this.field_70170_p);
            skeleton.func_82149_j((Entity)this);
            skeleton.func_70624_b(this.func_70638_az());
            skeleton.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            skeleton.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
            double vX = target.field_70165_t - this.field_70165_t;
            double vZ = target.field_70161_v - this.field_70161_v;
            double vH = Math.sqrt(vX * vX + vZ * vZ);
            skeleton.field_70159_w = vX / vH * 0.8 + this.field_70159_w * 0.2;
            skeleton.field_70181_x = 0.4;
            skeleton.field_70179_y = vZ / vH * 0.8 + this.field_70179_y * 0.2;
            skeleton.field_70122_E = false;
            this.field_70170_p.func_72838_d((Entity)skeleton);
            this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            skeleton.func_70656_aK();
            potion = ItemStack.field_190927_a;
        } else {
            potion = this.makeSplashPotion(this.field_70146_Z.nextFloat() < 0.2f ? PotionTypes.field_185253_y : PotionTypes.field_185252_x);
        }
        return potion;
    }

    @Override
    public void tryDrinkPotion() {
        if (this.potionThrowTimer <= 0) {
            if (this.field_70146_Z.nextFloat() < 0.15f && (this.func_70027_ad() || this.func_189748_bU() != null && this.func_189748_bU().func_76347_k()) && !this.func_70644_a(MobEffects.field_76426_n)) {
                this.usePotion(this.makePotion(PotionTypes.field_185241_m));
            } else if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(MobEffects.field_76427_o)) {
                this.usePotion(this.makePotion(PotionTypes.field_185248_t));
            } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                this.usePotion(this.makePotion(PotionTypes.field_185252_x));
            } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(MobEffects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                this.usePotion(this.makeSplashPotion(PotionTypes.field_185243_o));
            } else {
                this.tryDrinkPotionByType();
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a(TAG_SKELETONS, (byte)this.skeletonCount);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_SKELETONS, 99)) {
            this.skeletonCount = saveTag.func_74771_c(TAG_SKELETONS);
        }
    }
}

