/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.slime;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.slime.Entity_SpecialSlime;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityWatermelonSlime
extends Entity_SpecialSlime {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityWatermelonSlime.GET_TEXTURE_PATH("watermelon"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(14644857);
        info.weight = 50;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityWatermelonSlime.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Melon slices", Items.field_151127_ba);
        loot.addRareDrop("rare", "Glistening melon", Items.field_151060_bw);
        loot.addUncommonDrop("uncommon", "Slime color", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.PINK.func_176767_b()), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.LIME.func_176767_b()));
    }

    public EntityWatermelonSlime(World world) {
        super(world);
        this.getSpecialData().setBaseScale(1.5f);
    }

    @Override
    protected EntitySlime getSplitSlime() {
        return new EntityWatermelonSlime(this.field_70170_p);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.func_189101_db() ? LOOT_TABLE : LootTableList.field_186419_a;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.slimeExperienceValue += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_188791_g, 15.0);
    }

    @Override
    protected float typeSizeMultiplier() {
        return 0.765f;
    }

    @Override
    protected void adjustTypeAttributesForSize(int size) {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 2.0 * (double)size + 8.0);
    }

    protected void func_70664_aZ() {
        double distanceSq;
        EntityLivingBase target = this.func_70638_az();
        if (target != null && (distanceSq = this.func_70068_e((Entity)target)) < 25.0) {
            double vX = target.field_70165_t - this.field_70165_t;
            double vZ = target.field_70161_v - this.field_70161_v;
            double vH = Math.sqrt(vX * vX + vZ * vZ);
            this.field_70159_w = vX / vH * 1.16 + this.field_70159_w * 0.2;
            this.field_70181_x = 0.42;
            this.field_70179_y = vZ / vH * 1.16 + this.field_70179_y * 0.2;
            this.field_70160_al = true;
            return;
        }
        super.func_70664_aZ();
    }

    @Override
    protected void onTypeAttack(Entity target) {
        target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 0.8f), 0.21, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 0.8f));
        this.field_70159_w *= -0.2;
        this.field_70179_y *= -0.2;
    }
}

