/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.slime;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.slime.Entity_SpecialSlime;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityGrapeSlime
extends Entity_SpecialSlime {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityGrapeSlime.GET_TEXTURE_PATH("grape"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(0xB333B3);
        info.weightExceptions = BestiaryInfo.DEFAULT_THEME_MOUNTAIN;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityGrapeSlime.ADD_BASE_LOOT(loot);
        loot.addGuaranteedDrop("base", "Slime balls", Items.field_151123_aH, 1);
        loot.addUncommonDrop("uncommon", "Slime color", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.PURPLE.func_176767_b()));
    }

    public EntityGrapeSlime(World world) {
        super(world);
        this.getSpecialData().setFallDamageMultiplier(0.0f);
    }

    @Override
    protected EntitySlime getSplitSlime() {
        return new EntityGrapeSlime(this.field_70170_p);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.func_189101_db() ? LOOT_TABLE : LootTableList.field_186419_a;
    }

    @Override
    protected void adjustTypeAttributes() {
        ++this.slimeExperienceValue;
    }

    @Override
    protected void adjustTypeAttributesForSize(int size) {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0 * (double)size);
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.2);
    }

    protected void func_70664_aZ() {
        double distanceSq;
        EntityLivingBase target = this.func_70638_az();
        if (target != null && (distanceSq = this.func_70068_e((Entity)target)) > 36.0 && distanceSq < 144.0) {
            double vX = target.field_70165_t - this.field_70165_t;
            double vZ = target.field_70161_v - this.field_70161_v;
            double vH = Math.sqrt(vX * vX + vZ * vZ);
            this.field_70159_w = vX / vH * 1.1 + this.field_70159_w * 0.2;
            this.field_70181_x = 1.092;
            this.field_70179_y = vZ / vH * 1.1 + this.field_70179_y * 0.2;
            this.field_70160_al = true;
            return;
        }
        super.func_70664_aZ();
    }
}

