/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.slime;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.slime.Entity_SpecialSlime;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.material.Material;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityBlueberrySlime
extends Entity_SpecialSlime {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityBlueberrySlime.GET_TEXTURE_PATH("blueberry"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(7760828);
        info.weightExceptions = BestiaryInfo.DEFAULT_THEME_WATER;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityBlueberrySlime.ADD_BASE_LOOT(loot);
        loot.addRareDrop("rare", "Undersea loot", Items.field_151074_bl, Items.field_179562_cC, Items.field_179563_cD);
        loot.addUncommonDrop("uncommon", "Slime color", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
    }

    public EntityBlueberrySlime(World world) {
        super(world);
        this.getSpecialData().setImmuneToBurning(true);
        this.getSpecialData().setCanBreatheInWater(true);
    }

    @Override
    protected EntitySlime getSplitSlime() {
        return new EntityBlueberrySlime(this.field_70170_p);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.func_189101_db() ? LOOT_TABLE : LootTableList.field_186419_a;
    }

    @Override
    protected void adjustTypeAttributes() {
        ++this.slimeExperienceValue;
    }

    @Override
    protected void adjustTypeAttributesForSize(int size) {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, 1.0 * (double)size);
    }

    public boolean func_70072_I() {
        if (this.field_70170_p.func_72875_a(this.func_174813_aQ().func_72314_b(0.0, -0.4, 0.0).func_186664_h(0.001), Material.field_151586_h)) {
            this.field_70143_R = 0.0f;
            this.func_70066_B();
        }
        this.field_70171_ac = false;
        return false;
    }
}

