/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.skeleton;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.MobHelper;
import fathertoast.specialmobs.entity.skeleton.Entity_SpecialSkeleton;
import fathertoast.specialmobs.loot.LootTableBuilder;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityPoisonSkeleton
extends Entity_SpecialSkeleton {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityPoisonSkeleton.GET_TEXTURE_PATH("poison")), null, new ResourceLocation(EntityPoisonSkeleton.GET_TEXTURE_PATH("poison_overlay"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(7838824);
        info.weightExceptions = BestiaryInfo.DEFAULT_THEME_FOREST;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityPoisonSkeleton.ADD_BASE_LOOT(loot);
        ItemStack arrow = new ItemStack(Items.field_185167_i);
        PotionUtils.func_185188_a((ItemStack)arrow, (PotionType)PotionTypes.field_185254_z);
        loot.addUncommonDrop("uncommon", "Poison arrow", arrow);
    }

    public EntityPoisonSkeleton(World world) {
        super(world);
        this.getSpecialData().addPotionImmunity(MobEffects.field_76436_u);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        ++this.field_70728_aV;
    }

    @Override
    protected void onTypeAttack(Entity target) {
        if (target instanceof EntityLivingBase) {
            int duration = MobHelper.getDebuffDuration(this.field_70170_p.func_175659_aa());
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration));
        }
    }

    @Override
    @Nonnull
    protected EntityArrow func_190726_a(float distanceFactor) {
        EntityArrow arrow = super.func_190726_a(distanceFactor);
        if (arrow instanceof EntityTippedArrow) {
            int duration = MobHelper.getDebuffDuration(this.field_70170_p.func_175659_aa());
            ((EntityTippedArrow)arrow).func_184558_a(new PotionEffect(MobEffects.field_76436_u, duration));
        }
        return arrow;
    }
}

